#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/jvm_info.pl /main/4 2010/06/18 14:29:12 asunar Exp $
#
# jvm_info.pl
# 
# Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      jvm_info.pl - <one-line expansion of the name>
#      This script collects all the JVM related information 
#      and returns thesame which will be uploaded to a new 
#      table "MGMT_ECM_JVM_INFO"
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    asunar      06/18/10 - checking for javac.exe for Windows
#    asunar      05/13/10 - Creation
#
use strict;

use hostOSD;

use File::Spec;

use Config;
my ($jvm_loc) = @ARGV;

if ( $jvm_loc eq "" )
{
   if ( defined($ENV{JAVA_HOME}) ) 
   {
     $jvm_loc = $ENV{JAVA_HOME};
   }
   else {
      $jvm_loc = $ENV{CCR_JAVA_HOME};
   }
}
if ( $jvm_loc ne "" )
{
    my $version   = "";
    my $cmd     = "";
    my $out   = "";
    #Calling the JVMInf.java class to get the version and vendor
    $cmd = "$jvm_loc/bin/java -classpath $ENV{ORACLE_HOME}/ccr/lib/emocmclnt.jar oracle.sysman.ccr.collector.util.JVMInf";
    $out = `$cmd`;
    my @values = split("\n", $out); 
    my %JVMProps; 
    for (my $i = 0; $i < scalar(@values); $i++) 
    { 
       my ($key, $value) = split("=", $values[$i]); 
       $JVMProps{$key} = $value; 
    }
    my $javaVersion = $JVMProps{"java.version"}; 
    my $javaVendor = $JVMProps{"java.vendor"};  
    my $jvminfor = $JVMProps{"java.vm.info"};
    my $jvmName = $JVMProps{"java.vm.name"};
    my $jvmSpecName = $JVMProps{"java.vm.specification.name"};
    my $jvmSpecVendor = $JVMProps{"java.vm.specification.vendor"};
    my $jvmSpecVerion = $JVMProps{"java.vm.specification.version"};
    my $jvmVendor = $JVMProps{"java.vm.vendor"};
    my $jvmVersion = $JVMProps{"java.vm.version"};
    # Need to filter out '|' from all the variables to send
    # the correct number of values from this jvm_info.pl
    $javaVersion =~ s/\|//g;
    $javaVendor =~ s/\|//g;
    $jvminfor =~ s/\|//g;
    $jvmName =~ s/\|//g;
    $jvmSpecName =~ s/\|//g;
    $jvmSpecVendor =~ s/\|//g;
    $jvmSpecVerion =~ s/\|//g;
    $jvmVendor =~ s/\|//g;
    $jvmVersion =~ s/\|//g;
    my $OSNAME = $Config{'osname'};
    my $JDK = "";
    my $javac="";
    if ($OSNAME eq "MSWin32")
    {
     $javac = File::Spec->catfile($jvm_loc,"bin", "javac.exe");
    }
    else
    {
     $javac = File::Spec->catfile($jvm_loc,"bin", "javac");
    }
    if (-e $javac)
    {
       $JDK = "1";
    }
    else
    {
       $JDK = "0";
    }
     print "em_result=$jvm_loc|$javaVersion|$javaVendor|$JDK|$jvminfor|$jvmName|$jvmSpecName|$jvmSpecVendor|$jvmSpecVerion|$jvmVendor|$jvmVersion\n";
}
else
{
    print STDERR "em_error=No JAVA_HOME specified\n";
}

# End of the Program 
