# $Header: jvmprocstats.pl 21-nov-2002.14:16:17 dsinha Exp $
#
# jvmprocstats.pl
# 
# Copyright (c) 2001, 2002, Oracle Corporation.  All rights reserved.  
#
#    NAME
#      jvmprocstats.pl - returns statistics about the JVM process
#
#    DESCRIPTION
#      on Solaris returns:
#      em_result=<pid>|<pcpu>|<vsz>
#      where <pid> is the process id of the runtime environment
#            <pcpu> the % CPU usage of this process
#            <vsz> the virtual memory usage by this process in bytes
#
#    NOTES
#      
#
#    MODIFIED   (MM/DD/YY)
#    vsekuboy    10/24/02 - Changes for AIX
#    dsinha      11/21/02 - 
#    vsekuboy    10/10/02 - Added changes for HP and Linux
#    xxu         06/25/02 - remove /usr/local/bin/perl
#    itarashc    11/14/01 - fix jvm pid
#    sgrover     08/30/01 - fix pid file loc
#    aaitghez    05/29/01 - changing variable name.
#    aaitghez    05/29/01 - creation. provides information from OS about JVM pr
#    aaitghez    05/29/01 - Creation
# 

chomp ($os = `uname -s`) or die "Failed to run the uname command";
SWITCH: {
  $os eq "SunOS" && do {
                          chomp ($ver = `uname -r`);
                          if ( $ver !~ /^4./ ) {
                             $osType = "Sol";
                             last SWITCH;
                          }
                       };
  $os eq "HP-UX" && do {
                          $osType = "HP";
                          last SWITCH;
                       };

  $os eq "Linux" && do {
                          $osType = "LNX";
                          last SWITCH;
                       };
  $os eq "AIX" && do {
                          $osType = "AIX";
                          last SWITCH;
                       };
  die "Unsupported Operating System\n";
}

# My parent must be jvm.
$jvm_pid = getppid();

if(($osType eq "Sol") || ($osType eq "LNX")) { 
    $cmd = "ps -p $jvm_pid -o \"pid pcpu vsz\" ";
    $r = `$cmd` 
	or die "Could not execute ps";
    @lines = split("\n", $r);
    @result = split(" ", @lines[1]);
    print "em_result=".join("|", @result)."\n";
}
elsif($osType eq "HP") {
     $cmd = "ps -p $jvm_pid -l";
     $r = `$cmd` 
	 or die "Could not execute ps";
     @lines = split("\n", $r);
     @result = split(" ", @lines[1]);
     print "em_result=".@result[3]."|".@result[9]."\n";
}
elsif($osType eq "AIX") {
     $cmd = "ps -p $jvm_pid  -o pid,pcpu,vsz";
     $r = `$cmd` or die "Could not execute ps";
     @lines = split("\n", $r);
     @result = split(" ", @lines[1]);
     print "em_result=".join("|", @result)."\n";
}
