# $Header: kernel.pl 10-oct-2002.15:59:44 vsekuboy Exp $
#
# kernel.pl
# 
# Copyright (c) 2001, 2002, Oracle Corporation.  All rights reserved.  
#
#    NAME
#      kernel.pl - enumerates system settings from /etc/system
#
#    DESCRIPTION
#      gives a list of system settings from /etc/system file
#
#    NOTES
#      depends on semd_common.pl. Initial revision based on WGRUYTER's script
#
#    MODIFIED   (MM/DD/YY)
#    vsekuboy    10/10/02 - Added changes for HP and Linux
#    xxu         06/25/02 - remove /usr/local/bin/perl
#    dmshah      04/02/02 - Review comments
#    dmshah      04/01/02 - Adding HP-UX support for kernel params
#    vnukal      12/05/01 - Merged vnukal_kernel-metric-add
#    vnukal      12/03/01 - Creation
# 

require "semd_common.pl";

#target we are checking on
my $target;
$target = $ENV{EM_TARGET_NAME};


# Check platform we're running on
if(($osType = get_osType()) == -1) {
    print "em_error=unsupported OS\n";
    EMD_DEBUG("The OS is unsupported.\n", "$target");
    exit;
}

# Currently refuse all non-solaris platforms
if ($osType ne "SOL" || $osType ne "HP" ||  $osType ne "LNX") {
   EMD_TRACE("Sun Solaris, HP-UX and Linux are the only supported platform for this script\n");
}

# Prepare for multi-OS scripts
if ($osType eq "SOL") 
{
   %kernel = ();
   @DATA = `cat /etc/system`;
}
elsif ($osType eq "HP") 
{
   @DATA = `cat /stand/system`; 
}
elsif ($osType eq "LNX")
{
   @DATA = `/sbin/sysctl -a 2>/dev/null | grep "kernel\." | sed 's/kernel\.//g'`;
}

# only do DATA if there are elements
if (@DATA > 0) 
{
   foreach $line (@DATA) {
     # Trim string
     $line =~ s/^\s//;
     $line =~ s/\s$//;
     
     # Remove comments
     $line =~ s/\#.+$//;
     $line =~ s/\*.+$//;
     $line =~ s/^set\s+//;
     
     # Only take lines inf the form 'name=value'
     next if ($line !~ /.+=.+/);

     # Get values, and put in array
     ($name, $value) = split("=",$line,2);

     # Trim name and value parameters
     $name  =~ s/^\s//;
     $name  =~ s/\s$//;
     $value =~ s/^\s//;
     $value =~ s/\s$//;

     # Store in list
     $kernel{$name}=$value;
  }

  foreach $key (sort(keys(%kernel))) {
    print "em_result=$key|$kernel{$key}\n";
  }
}

# ----- EOF: kernel.pl ----- #

