# $Header: listenerload.pl 18-dec-2003.19:46:46 dkapoor Exp $
#
# listenerload.pl
# 
# Copyright (c) 2001, 2003, Oracle Corporation.  All rights reserved.  
#
#    NAME
#      listenerload.pl 
#
#    DESCRIPTION
#      retrieve listener load stats in the following format.
#      em_result=<number established connections>|<number refused connections>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    dkapoor     12/18/03 - return em_error on error 
#    dkapoor     10/30/03 - don't parse listener first 
#    dkapoor     04/23/03 - use generic method to get result
#    dkapoor     04/21/03 - parse listener for pswd
#    dkapoor     07/19/02 - remove connect data
#    xxu         06/25/02 - remove /usr/local/bin/perl
#    xxu         10/12/01 - set_lib_path (bug 2044793)
#    aaitghez    07/06/01 - die when error.
#    aaitghez    07/06/01 - bad merge fix.
#    aaitghez    07/02/01 - error_parse check.
#    aaitghez    06/29/01 - no trace.
#    aaitghez    06/28/01 - setting address.
#    aaitghez    07/02/01 - instance variable naming convention
#    aaitghez    06/19/01 - removing debug calls.
#    aaitghez    06/01/01 - adding debug and making use of common utilities.
#    njagathe    05/29/01 - Set ORACLE_HOME instead of LSNR_ORACLE_HOME
#    aaitghez    05/18/01 - perl version of ListenerLoad.tcl.
#    aaitghez    05/18/01 - Creation
# 

use strict;
require "semd_common.pl";
require "$ENV{EMDROOT}/sysman/admin/scripts/db/net/listenerUtil.pl";

$ENV{ORACLE_HOME} = $ENV{LSNR_ORACLE_HOME};
$ENV{TNS_ADMIN} = $ENV{LSNR_ORA_DIR};

set_lib_path( $ENV{LSNR_ORACLE_HOME});

my $machine = $ENV{LSNR_MACHINE};
my $port = $ENV{LSNR_PORT};
my $name = $ENV{LSNR_NAME};

my $listenerFile = $ENV{LSNR_ORA_DIR} . "/listener.ora";
my $executable= $ENV{LSNR_ORACLE_HOME}."/bin/lsnrctl";
my $command = "services (DESCRIPTION=(ADDRESS=(PROTOCOL=TCP)(HOST=$machine)(PORT=$port)))";

my $r;
eval
{
 $r = getResult($executable,$command,$listenerFile,$name,1);
};
if($@)
{
    print STDERR "em_error=could not execute lsnrctl for $ENV{LSNR_NAME}\n";
    exit (-1);
}
#if (!($r = `$cmd services "$address"`)) {
#    print "em_error=could not execute lsnrctl for $ENV{LSNR_NAME}\n";
#    exit;
#}


my $established = 0;
my $refused = 0;
my @res1;
my @res2;
my @error_parse;

#check for errors:
@error_parse = split(m/TNS/, $r);
if (scalar(@error_parse) > 1) {
    $r =~ s/^\s*|\s*&//g;
    $r =~ s/\n/ /g;
    print STDERR "em_error=$r\n";
    exit(-1);
}

#loop through the results
my @res = split(m/established/, $r);
for (my $i = 1; $i < (scalar @res); $i++) {
    @res1 = split(m/:/, @res[$i]);
    @res2 = split(m/\s/, @res1[1]);
    $established += @res2[0];
    @res2 = split(m/\s\n/, @res1[2]);
    $refused += @res2[0];
}				

print "em_result=$established|$refused\n";

