# $Header: emll/sysman/admin/scripts/livelink_packages.pl /main/9 2009/02/25 05:21:51 tsubrama Exp $
#
# Package : livelink_packages.pl
#
# Copyright (c) 2002, 2009, Oracle and/or its affiliates.All rights reserved. 
#
#   NAME
#       livelink_packages.pl
#
#   DESCRIPTION
#       Collects the livelink packages that are deployed in the home
#
#   returns EM_RESULT = 
# with values for
# em_result =PACKAGE_NAME|PACKAGE_VERSION|BUILD_DATE
#
#   NOTES
#
#   MODIFIED     (MM/DD/YY)
#     tsubrama 02/06/09 - no jdk dependency
#     jsutton  02/23/07 - Make curdir an absolute path
#     ndutko   08/31/06 - Expand the MANIFEST in a temporary directory
#     jsutton  07/20/06 - Need more info from packages 
#     jsutton  06/09/06 - Merge changes from 10.2.3 stream to MAIN 
#     jsutton  02/03/06 - Use jar vs. zip to extract manifest 
#     ndutko   10/17/05 - Search for unzip in more than /usr/bin 
#     ndutko   08/03/05 - ndutko_code_checkin
#     ndutko   06/08/05 - Creation
##*************************************************************
package livelink_packages;

use strict;
use File::Spec;
use File::Basename;
use File::Temp qw/tempdir/;
use Config;

BEGIN
{
    $livelink_packages::liveLinkDir = shift;
    if (! defined $livelink_packages::liveLinkDir)
    {
        print "em_warning=livelink_home is not defined\n";
        exit;
    }
    my $jarFNM = "jar";
    my $ocmJarUtilFNM = "ocmJarUtil";
    if ($Config{'osname'} eq "MSWin32")
    {
        $jarFNM = $jarFNM . ".exe";
        $ocmJarUtilFNM = $ocmJarUtilFNM .".bat";
    }
    my $javaHomeJar = File::Spec->catdir($ENV{CCR_JAVA_HOME},"bin",$jarFNM);
    my $oracleHomeJar = File::Spec->catdir(
                           dirname($livelink_packages::liveLinkDir),
                           "jdk", "bin", $jarFNM);
    my $ocmJarUtil = File::Spec->catdir($ENV{CCR_HOME},"bin",$ocmJarUtilFNM);

    if ( -f $javaHomeJar )
    {
        $livelink_packages::JAR = $javaHomeJar;
    }
    elsif ( -f $oracleHomeJar )
    {
        $livelink_packages::JAR = $oracleHomeJar;
    }
    elsif ( -f $ocmJarUtil )
    {
        $livelink_packages::JAR = $ocmJarUtil;
    }    
}

use constant LIVELINK_ROOT => $livelink_packages::liveLinkDir;
use constant LIVELINK_INVENTORY => File::Spec->catdir(LIVELINK_ROOT, "inventory");

my @packages = getPackages();
foreach my $package (@packages)
{    
    my $refPackage = getDetails($package);
    printf "em_result=%s|%s|%s|%s|%s\n",
            $refPackage->{PACKAGE_NAME}, 
            $refPackage->{PACKAGE_VERSION},
            $refPackage->{BUILD_DATE},
            $refPackage->{PACKAGE_PLATFORM},
            $refPackage->{PACKAGE_ARCHITECTURE};
}

sub getPackages()
{
    opendir INVENTORY, LIVELINK_INVENTORY or
        die "Unable to open LiveLink deployment directory";
    
    my $package;
    my @tmp;
    while (defined($package = readdir(INVENTORY)))
    {
        my $fullSpec = File::Spec->catfile(LIVELINK_INVENTORY, $package);
        if (-f $fullSpec && $package =~ /.jar$/)
        {             
            push @tmp, $fullSpec;
        }
    }
    
    closedir INVENTORY;
    return @tmp;
}

sub getDetails($)
{
    my $packageFNM = shift;
    if ($Config{'osname'} eq "MSWin32")
    {
        $packageFNM = Win32::GetShortPathName($packageFNM);
    }
    my $refPackage = {};

    # create a temporary directory to unpack the MANIFEST into
    my $curdir=File::Spec->rel2abs(File::Spec->curdir());
    my $tmpdir=tempdir();
    chdir($tmpdir);

    system("$livelink_packages::JAR xf $packageFNM META-INF/MANIFEST.MF");
    
    open MANIFEST,"<".File::Spec->catfile(".", "META-INF", "MANIFEST.MF")
        or die "Unable to open manifest, $!\n";
    
    my $line;
    LINE:
    while($line = <MANIFEST>)
    {
        chomp $line;
        my ($name, $value) = ($line =~ /^(.*?)\s*:\s*([\w. :\/\-]*)/);
        if ($name =~ /^package-name$/)
        {
            $refPackage->{PACKAGE_NAME} = $value;
            next LINE;
        }
        
        if ($name =~ /^package-version$/)
        {
            $refPackage->{PACKAGE_VERSION} = $value;
            next LINE;
        }

        if ($name =~ /^package-date$/)
        {
            $refPackage->{BUILD_DATE} = $value;
            next LINE;
        }

        if ($name =~ /^package-platform$/)
        {
            $refPackage->{PACKAGE_PLATFORM} = $value;
            next LINE;
        }

        if ($name =~ /^package-architecture$/)
        {
            $refPackage->{PACKAGE_ARCHITECTURE} = $value;
            next LINE;
        }
    }
    
    close MANIFEST;

    # Reset the working directory to whence we started.
    chdir ($curdir);

    # remove the temporary directory.
    unlink File::Spec->catfile($tmpdir, "META-INF", "MANIFEST.MF");
    rmdir File::Spec->catdir($tmpdir, "META-INF");
    rmdir $tmpdir;
    
    return $refPackage;
}
# End of the Program
