# $Header: emll/sysman/admin/scripts/livelink_params.pl /main/10 2008/11/13 11:56:51 pparida Exp $
#
# Package : livelink_params.pl
#
# Copyright (c) 2002, 2008, Oracle and/or its affiliates. All rights reserved. 
#
#   NAME
#       livelink_params.pl
#
#   DESCRIPTION
#       Collects the livelink parameters that affect the behavior of
#        livelink collections.
#
#   returns EM_RESULT =
# with values for
# em_result=Category|Property|Value|ConfigFile
#
#   NOTES
#
#   MODIFIED     (MM/DD/YY)
#     pparida  10/29/08 - pparida_ocm_status_metric: Also read sched.state
#                         properties.
#     glavash  04/14/08 - add ccr.registration_ct to list of params to ignore
#                         bug 6970420
#     ndutko   10/10/07 - XbranchMerge ndutko_bug6467738 from st_emll_10.2.7
#     ndutko   10/10/07 - Collect collector config versions
#     ndutko   10/10/07 - Look for parameters between the CCR_HOME and
#                         CCR_CONFIG_HOME locations
#     jsutton  09/04/07 - Remove xtraneous print
#     glavash  12/14/06 - cutover to use of ocmprop.pm
#     ndutko   03/24/06 - Filter the proxy properties out 
#     ndutko   02/27/06 - Exclude empty lines from the collection 
#     ndutko   10/23/05 - mine the ccr.properties 
#     ndutko   08/03/05 - ndutko_code_checkin
#     ndutko   06/08/05 - Creation
##*************************************************************

package livelink_params;

use strict;
use File::Spec;
use File::Basename;

use ocmprop;

my @configFiles =
  ( "collector.properties", "ccr.properties", "emCCRenv", "collector_config.inventory", "sched.properties" );

my @stateFiles = ( "sched.state" );

# Mine the configuration files looking in the LiveLink_Root directory
# under the config directory and the default properties are default
# directory.

#this routine requires CCR_HOME to be defined

if ( !defined $ENV{'CCR_HOME'} )
    {
        print "em_warning=CCR_HOME is not defined\n";
        exit;
    }

foreach my $config (@configFiles) 
{
    my $categoryName  = fileparse( $config, qr{\..*} );
    my $refProperties = getConfigProperties($config);
    printProperties($categoryName, $refProperties);

}

foreach my $state (@stateFiles) 
{
    my $categoryName  = fileparse( $state, qr{\..*} );
    my $refProperties = getStateProperties($state);
    printProperties($categoryName, $refProperties);

}


# Function to print the properties
sub printProperties($$)
{
  my ($categoryName, $refProperties) = @_;
  PROP:
  foreach my $property ( keys %$refProperties ) 
  {
      my $refProperty = $refProperties->{$property};
          next PROP if (filterProperty($property));
      # print "$property , $refProperty->{VALUE} \n";
      printf "em_result=%s|%s|%s|%s\n", $categoryName, $property,
        $refProperty->{VALUE}, $refProperty->{FILENAME};
  }
  return 0;
}

# Function to filter named properties
sub filterProperty($)
{
    my @propertyNames=qw/http.proxyUser http.proxyPassword ccr.proxypswd.seed ccr.registration_ct schedKey portNum sched_pid last_ps_collectionTime last_collectionTime/;
    my $property = shift;

    foreach my $filter (@propertyNames)
    {
        if ( $property =~ /^${filter}$/ ){ return 1 }
    }

    return 0;
}
# End of the Program

