#!/usr/local/bin/perl
# 
# $Header: lsnrCmdStatus.pl 04-jul-2005.15:06:13 dsukhwal Exp $
#
# lsnrCmdStatus.pl
# 
# Copyright (c) 2004, 2005, Oracle. All rights reserved.  
#
#    NAME
#      lsnrCmdStatus.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    dsukhwal    06/30/05 - support flood control for all policies 
#    dkjain      06/27/05 - Adding check for oms ver 
#    dsukhwal    05/02/05 - connect to complete listener address 
#    dsukhwal    01/07/05 - Fix lsnr_default_name 
#    rmadampa    11/29/04 - fix for log_status to work with non-default 
#                           listeners, change to getResult to support 
#                           this 
#    dkjain      11/07/04 - Changing property string value to old value 
#    dkjain      10/08/04 - dkjain_esa_impl_init
#    dkjain      10/08/04 - Creation
# 
#    Implementation
#    Invoke the lsnrctl with the 'show log_status' command
#    Capture the setting for the parameter and print it out
#    as em_result=<param_setting>|<Value>.
use strict;
require "semd_common.pl";
require "$ENV{EMDROOT}/sysman/admin/scripts/db/net/listenerUtil.pl";
require "$ENV{EMDROOT}/sysman/admin/scripts/db/esaUtils.pl";

$ENV{ORACLE_HOME} = $ENV{LSNR_ORACLE_HOME};

set_lib_path ($ENV{LSNR_ORACLE_HOME});
$ENV{TNS_ADMIN} = $ENV{LSNR_ORA_DIR};
my $machine = $ENV{LSNR_MACHINE};
my $port = $ENV{LSNR_PORT};
my $name = $ENV{LSNR_NAME};
my $listenerFile = $ENV{LSNR_ORA_DIR} . "/listener.ora";
my $executable= $ENV{LSNR_ORACLE_HOME}."/bin/lsnrctl";
my $address="(ADDRESS=(PROTOCOL=TCP)(HOST=$machine)(PORT=$port))";
my $oms_ver=$ENV{OMS_VERSION};

   if(!($oms_ver =~ "10.1")){ 
    lsnr_default_name();
   } #upload only for 10gR2 n onwards
   lsnr_log_status();
   lsnr_pwd_status();

sub lsnr_default_name {
my $maxRows = $ENV{'DEFNAMEMAX'};
if(!compareNegInf(0,$maxRows)){
    return;
}
my @commands = ("set current_listener $address","status");
my $command = \@commands;
my $result ;
eval
{
    $result = getResult($executable,$command,$listenerFile,$name);
};

if($@)
{
    print "em_error=Failed to run lsnrctl\n";
    exit;
}

my $curr_listener = " ";

## parse result
my @info = split(/\n/, $result);
if ($#info < 0)
{
    print "em_error=Failed to run lsnrctl, result=$result\n";
    exit;
}
my $property = "lsnr_default_name";
my $line;
my $i=0;
foreach $line (@info)
{
    if ($line =~ /^*TNS-12541/i)
    {
        print "em_error=Failed to run lsnrctl, result=$result\n";
        exit;
    }

    if($line =~ /^(\s*)Alias(\s+)(.*)/i)
    {
        $curr_listener = $3;
        last;
    }
}

print "em_result=$property=$curr_listener\n";
}

sub lsnr_log_status {
my $maxRows = $ENV{'LOGSTATMAX'};
if(!compareNegInf(0,$maxRows)){
    return;
}
my @command = ("set current_listener $address", "show log_status");
my $result ;

eval
{
    $result = getResult($executable,\@command,$listenerFile,$name);
};

if($@)
{
    print "em_error=Failed to run lsnrctl\n";
    exit;
}

my $log_status = " ";

## parse result
my @info = split(/\n/, $result);
if ($#info < 0)
{
    print "em_error=Failed to run lsnrctl, result=$result\n";
    exit;
}

my $line;
foreach $line (@info)
{
    if ($line =~ /^*TNS-12541/i)
    {
        print "em_error=Failed to run lsnrctl, result=$result\n";
        exit;
    }

    if ($line =~ /^*parameter \"log_status\" set to\s+(.*)/i)
    {
        $log_status = $1;
        last;
    }
 }

 print "em_result=loggingStatus=$log_status\n";
}
sub lsnr_pwd_status{
my $maxRows = $ENV{'PWDMAX'};
if(!compareNegInf(0,$maxRows)){
    return;
}
my $command = "status $address";
my $result ;

eval
{
 $result = getResult($executable,$command,$listenerFile,$name);
};
if($@)
{
    print "em_error=Failed to run lsnrctl\n";
    exit;
}


my $sec_status = " ";

## parse result
my @info = split(/\n/, $result);
if ($#info < 0)
{
    print "em_error=Failed to run lsnrctl, result=$result\n";
    exit;
}

my $line;
foreach $line (@info)
{
    if ($line =~ /^*TNS-12541/i)
    {
        print "em_error=Failed to run lsnrctl, result=$result\n";
        exit;
    }
    
    if ($line =~ /^\s*Security\s+(.*)/i)
    {
        $sec_status = $1;
        last;
    }
}

#
# The 10g version of the 'lsnrctl status' produces different output
# than it did in prior versions. We will convert the new format to
# match the older format
#
if ($sec_status =~ /^\s*ON:\s*Local/i) 
{
    $sec_status = "OFF";
}
else 
{
    if ($sec_status =~ /^\s*ON:\s*Pass/i) 
    {
        $sec_status = "ON";
    }
 }

 print "em_result=listenerPwd=$sec_status\n";  
}


