# Copyright (c) 2001, 2003, Oracle Corporation.  All rights reserved.  
#
#    NAME
#     lsnr_admin_status.pl
#
#    DESCRIPTION
#     collect listener's ADMIN_RESTRICTIONS parameter and value from
#	  listener.ora file
#
#    MODIFIED    (MM/DD/YY)
#     rmadampa    10/07/03 - regex fix 
#     rmadampa    09/23/03 - Added new tests for lsnr metric colln error condn 
#                            cases and related fixes in fetchlet scripts 
#     eujang      09/04/03 - eujang_esm_init_no_intgr 
#     rmadampa    08/08/03 - Created
#
# Summary
#    Print out the setting for the ADMIN_RESTRICTIONS_<lsnr_name> parameter
#    or NONE if not found
#
# Implementation
#    The ADMIN_RESTRICTIONS parameter is specified in 
#    the listener.ora file for each listener as
#
#     ADMIN_RESTRICTIONS_<lsnr_name>=ON|TRUE|OFF|FALSE
#
#    and is not case-sensitive. Search the listener.ora file for
#    the presence of this parameter starting on a new line. Prints
#    the result as em_result=<none_or_param_value>|<lsnr_name_and_desc>.
#    E.g., em_result=listenerAdmin=ON
#	 or, em_result=listenerAdmin=NONE
use strict;

my $listenerFile = $ENV{LSNR_ORA_DIR} . "/listener.ora";
my $name = $ENV{LSNR_NAME};

my $paramValue;
my $line;
my @info = parseFile($listenerFile);
if ($@ || $#info < 0) 
{
	print "em_error=Failed to read listener.ora file\n";
	exit;
}

foreach $line (@info)
{
	#check for the ADMIN_RESTRICTIONS parameter beginning on a
	#new line without any leading whitespace. lsnrctl doesnt
	#recognize the parameter setting otherwise.
    if ($line =~ /^ADMIN_RESTRICTIONS_(.*)/i) 
    {
        my @nvpair = split('=', $1);

		#need to verify presence of '=' and a value after it
		if ($#nvpair == 1) 
		{
			if ($nvpair[0] =~ /^$name\s*$/i)
			{
				#found ADMIN_RESTRICTIONS_<lsnr_name>
				$paramValue = $nvpair[1];
				#trim the leading and trailing spaces
				$paramValue =~ s/^\s*(.*?)\s*$/$1/;
				last;
			}
		}
    }
}

if (!defined $paramValue) 
{
    print "em_result=listenerAdmin=NONE\n";
}
else
{
    print "em_result=listenerAdmin=$paramValue\n";
}

#Parse a file and return an array containing the lines
sub parseFile
{
    my ($configFile) = @_;
	my $CONFIG_FILE_READER;

	if(!-e $configFile)
	{
		print "em_error=File does not exist[$configFile]\n";
		return;
	}

	open($CONFIG_FILE_READER, $configFile);
	if(!(defined $CONFIG_FILE_READER))
    {
        print "em_error=File cound not be open for reading [$configFile]\n";
        return;
    }
    my @info;
    my $line;
    while($line = <$CONFIG_FILE_READER>)
    {
        chomp($line);	
        push(@info,$line);
    }

    close $CONFIG_FILE_READER;
    return @info;
}
