# Copyright (c) 2001, 2004, Oracle. All rights reserved.  
#
#    NAME
#     lsnr_log_status.pl
#
#    DESCRIPTION
#     get listener logging status
#
#    MODIFIED    (MM/DD/YY)
#    rmadampa     11/29/04 - fix for log_status to work with non-default 
#                            listeners, change to getResult to support 
#                            this 
#    rmadampa     03/02/04 - fix for bug 3469142 - removed hard coded PATH 
#    rmadampa     09/23/03 - Added new tests for lsnr metric colln error condn 
#                            cases and related fixes in fetchlet scripts 
#    rmadampa     09/23/03 - 
#    eujang       09/04/03 - eujang_esm_init_no_intgr 
#    rmadampa     08/13/03 - Creation
#
# Summary
#    Print out logging status of the listener instance 
#
# Implementation
#    Invoke the lsnrctl with the 'show log_status' command
#    Capture the setting for the parameter and print it out
#	 as em_result=listenerLogStatus=<param_setting>.
use strict;
require "semd_common.pl";
require "$ENV{EMDROOT}/sysman/admin/scripts/db/net/listenerUtil.pl";

$ENV{ORACLE_HOME} = $ENV{LSNR_ORACLE_HOME};

set_lib_path ($ENV{LSNR_ORACLE_HOME});
$ENV{TNS_ADMIN} = $ENV{LSNR_ORA_DIR};

my $name = $ENV{LSNR_NAME};

my $listenerFile = $ENV{LSNR_ORA_DIR} . "/listener.ora";
my $executable= $ENV{LSNR_ORACLE_HOME}."/bin/lsnrctl";
my @command = ("set current_listener $name", "show log_status");

my $result ;

eval
{
    $result = getResult($executable,\@command,$listenerFile,$name);
};

if($@)
{
    print "em_error=Failed to run lsnrctl\n";
    exit;
}

my $log_status = " ";

## parse result
my @info = split(/\n/, $result);
if ($#info < 0)
{
    print "em_error=Failed to run lsnrctl, result=$result\n";
    exit;
}

my $line;
foreach $line (@info)
{
    if ($line =~ /^*TNS-12541/i)
    {
        print "em_error=Failed to run lsnrctl, result=$result\n";
        exit;
    }

    if ($line =~ /^*parameter \"log_status\" set to\s+(.*)/i)
    {
        $log_status = $1;
        last;
    }
}

print "em_result=loggingStatus=$log_status\n";
