#!/usr/local/bin/perl
# 
# $Header: maxRowCount.pl 26-sep-2005.17:16:16 dsukhwal Exp $
#
# maxRowCount.pl
# 
# Copyright (c) 2005, Oracle. All rights reserved.  
#
#    NAME
#      maxRowCount.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    dsukhwal    09/26/05 - use bulk sub for maxCount 
#    dsukhwal    06/30/05 - add flood control for all 
#    dsukhwal    06/06/05 - limit number of rows for win32 
#    dsukhwal    05/26/05 - dsukhwal_bug4369815
#    dsukhwal    05/09/05 - Creation
# 

require "$ENV{EMDROOT}/sysman/admin/scripts/esa_config.pl";
my @instanceOOTBPolicies = qw(Umask_Setting Log_Archive_Destination_Permission Log_Archive_Destination_Owner Log_Archive_Duplex_Destination_Permission Log_Archive_Duplex_Destination_Owner Oracle_Home_Executable_Files_Owner Oracle_Home_File_Permission Oracle_Home_Executable_Files_Permission Utl_File_Directory Utl_File_Dir_for_9iPlus_Versions ifile_File_Permission initora_File_Permission spfile_Permission Audit_File_Destination User_Dump_Destination Background_Dump_Destination Core_Dump_Destination OS_Authenticate_Prefix_Domain PUBLIC_Trace_Files Remote_Listener_Instances Audit_Trail Os_Authent_Prefix Sql92_Security DB_Link_Global_Name Secure_OS_Audit_Level Remote_OS_Role Remote_OS_Authentication Remote_Password_File);

my @lsnrOOTBPolicies = qw(Lsnr_Host_Name Lsnr_Ora_Restrict_Perms Lsnr_Tracefile_Perm_Policy Lsnr_Tracefile_Own_Policy Lsnr_Tracedir_Perm_Policy Lsnr_Tracedir_Own_Policy Lsnr_Logfile_Perm_Policy Lsnr_Logfile_Own_Policy Listener_Direct_Administration Sqlnet_Ora_Restrict_Perms sqlnet_Client_Log_Dir sqlnet_Client_Log_Dir_Owner sqlnet_Server_Log_Dir sqlnet_Server_Log_Dir_Owner sqlnet_Client_Trace_Dir sqlnet_Client_Trace_Dir_Owner sqlnet_Server_Trace_Dir sqlnet_Server_Trace_Dir_Owner Listener_Default_Name Listener_Logging_Status Listener_Password Sqlnet_Allowed_Logon_Version);


my @dbOOTBPolicies = qw(DB_Link_With_Password Unlimited_Table_Space_Quota Password_Life_Time Password_Reuse_Max Password_Reuse_Time Password_Locking_Time Password_Grace_Time Well_known_Accounts Default_Passwords System_Privileges_To_Public Unlimited_login_attempts Oracle_Home_Data_Files_Permission DB_control_files_Permission Access_To_AUD_Table Access_To_USER_HISTORY_Table Access_To_SOURCE_Table Access_To_LINK_Table Access_To_USER_Table Access_To_STATSSQLTEXT_Table Access_To_STATSSQL_SUMMARY_Table Access_To_ALL_SOURCE_View Access_To_DBA_ROLES_View Access_To_DBA_SYS_PRIVS_View Access_To_DBA_ROLE_PRIVS_View Access_To_DBA_TAB_PRIVS_View Access_To_DBA_USERS_View Access_To_ROLE_ROLE_PRIVS_View Access_To_USER_TAB_PRIVS_View Access_To_USER_ROLE_PRIVS_View Excessive_PUBLIC_EXECUTE_privileges EXECUTE_UTL_FILE_Privileges_To_PUBLIC);

my $toPrint="em_result=";
if($ARGV[0] eq "instance"){
    my %instHash = get_max_upload_rowcount_bulk("instance", @instanceOOTBPolicies);
    for (my $i=0;$i<@instanceOOTBPolicies;$i++){
        my $maxRows = $instHash{$instanceOOTBPolicies[$i]};
        if(!defined($maxRows)){
            $maxRows = 0;
        }
        if((@instanceOOTBPolicies-1) == $i){
            $toPrint = $toPrint.$maxRows."\n";
        }
        else{
            $toPrint = $toPrint.$maxRows.'|';
        }
    }
}
elsif($ARGV[0] eq "listener"){
    my %lsnrHash = get_max_upload_rowcount_bulk("oracle_listener",@lsnrOOTBPolicies);
    for (my $i=0;$i<@lsnrOOTBPolicies;$i++){
        my $maxRows = $lsnrHash{$lsnrOOTBPolicies[$i]};
        if(!defined($maxRows)){
            $maxRows = 0;
        }
        if((@lsnrOOTBPolicies-1) == $i){
            $toPrint = $toPrint.$maxRows."\n";
        }
        else{
            $toPrint = $toPrint.$maxRows.'|';
        }
    }
}
elsif($ARGV[0] eq "database"){
    my %dbHash = get_max_upload_rowcount_bulk("database", @dbOOTBPolicies);
    for (my $i=0;$i<@dbOOTBPolicies;$i++){
        my $maxRows = $dbHash{$dbOOTBPolicies[$i]};
        if(!defined($maxRows)){
            $maxRows = 0;
        }
        if((@dbOOTBPolicies-1) == $i){
            $toPrint = $toPrint.$maxRows."\n";
        }
        else{
            $toPrint = $toPrint.$maxRows.'|';
        }
    }
}
    
print "$toPrint";

