#!/usr/local/bin/perl
# 
# $Header: emagent/sysman/admin/scripts/mwm/exalogicUtil.pm /main/4 2011/12/30 10:50:41 sasachde Exp $
#
# exalogicUtil.pm
# 
# Copyright (c) 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      exalogicUtil.pm - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    sasachde    12/26/11 - Using complete path of imageinfo
#    sasachde    12/14/11 - Changing the logic to fetch exalogic version using
#                           imageinfo command
#    sasachde    11/23/11 - Fix for bug#13423460
#    sasachde    10/24/11 - Creation
# 
package mwm::exalogicUtil;

use strict;
use Exporter 'import';
require "emd_common.pl";

our @EXPORT = qw(
    getExalogicId
    getExalogicVersion
    getExalogicAssoc
);

sub getExalogicId
{
  my $exalogicId;
  #########################################################
  ## File from exalogic Id be retrieved
  my $testFile="/var/exalogic/info/em-context.info";
  if(!open(IN, "< $testFile"))
  { 
    return "";
  }

  my $ibndOut;
  my $ibndStatus;

  while (<IN>)
  {
    $ibndOut = $_;
    my ($newString) = $ibndOut;
    my @words = split(/=/,trim($newString));
    if(trim($words[0]) eq "ExalogicID")
    {
       $exalogicId = $words[1];
       return trim($exalogicId);
    }
    else
    {
      return "";
    }
  }
}

# Perl trim function to remove whitespace from the start and end of the string
sub trim($)
{
        my $string = shift;
        $string =~ s/^\s+//;
        $string =~ s/\s+$//;
        return $string;
}

sub getExalogicVersion
{
  my $version = "";
  my @result = `/usr/sbin/imageinfo 2>&1`;
  if ( $? == -1 )
  {
     EMD_PERL_DEBUG("imageinfo command failed: $!\n");  
  }
  else
  {
     for my $line (@result) 
     {
       # Remove whitespace
       $line = trim($line);
       
       # Skip empty lines
       if (length($line) == 0)
       {
         next;
       }
      
       # Split the line using token /:/
       my @words = split(/:/, $line);
       if(trim($words[0]) eq "Image version")
       {
         $version = $words[1];
         return trim($version);
       }
       else
       {
         next;
       }
     }
  }

  if($version eq "")
  {
    return "1.0.0.2.0";
  }
}

sub getExalogicAssoc
{
  my $exlID = getExalogicId();
  if($exlID eq "")
  {
    return "";
  }
  else
  {
    return "em_result=member_of||exa_rack|$exlID";
  }
}
