# $Header: nntp_service_test.pl 03-aug-2005.20:39:25 fsalim Exp $
#
# nntp_service_test.pl
# 
# Copyright (c) 2003, 2005, Oracle. All rights reserved.  
#
# NAME
# nntp_service_test.pl - <one-line expansion of the name>
#
# DESCRIPTION
# This script posts and retrieves a message from a news server
# returns down status if the server could not be contacted.
#
# NOTES
# Uses Net::NNTP
#
# MODIFIED   (MM/DD/YY)
#    fsalim      08/03/05 - Fix for bug 4528606 
#    vesriniv    07/14/05 - fix success string 
#    fsalim      07/08/05 - fix4478756
#    fsalim      07/04/05 - To return the error status message 
#    mbisarya    12/13/04 - mbisarya_testtypechanges
#    skpanigr    12/08/04 - Creation
# 

use Net::NNTP;
use Time::HiRes;
use Getopt::Long; # set up to accept user input
#NNTP parameters
GetOptions(\%cmdLine,
            "BeaconName=s",
            "TxnName=s",
            "retryinterval=i",
            "numretries=i",
            "nntp_address=s",
            "nntp_newsgroup=s");

my $beaconName = $cmdLine{"BeaconName"};
my $txnName = $cmdLine{"TxnName"};
my $nntp_address = $cmdLine{"nntp_address"};
my $nntp_newsgroup = $cmdLine{"nntp_newsgroup"};
my $nntp_fail_count = $cmdLine{"numretries"};
my $retryinterval = $cmdLine{"retryinterval"};
$nntp_sender_id="EM\@$nntp_address";
$total_time = 0;
$connect_time = 0;
$post_time = 0;
$read_time = 0;
$errTxt = "Success";

print "Host: $nntp_address, Sender: $nntp_sender_id, Newsgroup: $nntp_newsgroup\n";

# the number of failed login try 
$fail_count = 0;

# Successful login indicator
$status = 0;

$start_time = Time::HiRes::time();

do 
{
   	sleep $retryinterval if $fail_count > 0;

	#default timeout is 120 sec
	$nntp = new Net::NNTP($nntp_address);
	if (defined $nntp) 
	{
		$status = 1;
	}
	else 
	{
      	$fail_count++;
	}
	print "NNTP Login Count = $fail_count, status = $status\n";

}while ($fail_count < $nntp_fail_count && $status == 0);


if ($status == 1)
{
    $connect_time = Time::HiRes::time() - $start_time;

    @header = ("Newsgroups: $nntp_newsgroup", "Subject: EMail NNTP Inbound Service Status check [$start_time]" ,"From: $nntp_sender_id");
    @body = ("This is an automated message posted by Oracle Enterprise Manager Grid Control");
    
    $start_time = Time::HiRes::time();

    $postrslt = $nntp->post(@header,"",@body);

    $post_time = Time::HiRes::time() - $start_time;

    if( not defined $postrslt ) {
      $post_time = 0;
    }

    $start_time = Time::HiRes::time();

    my $tmpGrp = $nntp->group($nntp_newsgroup); 
    if (not defined $tmpGrp) 
    { 
         $status = 0;
	 $errTxt = "Could not find the News Group $nntp_newsgroup. Please check the specified News Group.";
    } 

    @art = $nntp->article;

    $read_time = Time::HiRes::time() - $start_time;    
    if( not defined @art) { 
         $read_time = 0; 
    } 

    $post_time = toMilliSec($post_time);  
    $connect_time = toMilliSec($connect_time);  
    $read_time = toMilliSec($read_time);
    $total_time = $connect_time + $post_time + $read_time;

    printf ("em_result=$txnName|$beaconName|$status|$total_time|$connect_time|$post_time|$read_time|$errTxt\n");
    $nntp->quit;  
}
else
{
    $errTxt = "Could not connect to nntp server, please check NNTP Address."; 
    print "Connection failed\n";
    $status = 0;
     printf ("em_result=$txnName|$beaconName|$status|$total_time|$connect_time|$post_time|$read_time|$errTxt\n");
}

sub toMilliSec 
{
    my ( $time_in_sec) = @_;
    return $time_in_sec * 1000;
}
