# $Header: oc4jjvmresource.pl 01-dec-2004.10:53:15 bkesavan Exp $
#
# oc4jjvmresource.pl
# 
# Copyright (c) 2002, 2004, Oracle. All rights reserved.  
#
#    NAME
#      oc4jjvmresource.pl - gets cpu and memory usage for each oc4j JVM
#
#    DESCRIPTION
#      oc4jjvmresource.pl <oracle_home> <oc4j-instance-name>
#
#      where:
#         <oracle_home> is the oracle home in which the iAS is installed
#         <instance_name> is the instance name of the oc4j (such as home)
#
#    returns: 
#      em_result=<pid>|<cpuUsage>|<physicalMemoryUsage>
#      em_result=<pid>|<cpuUsage>|<physicalMemoryUsage>
#
#      where:
#         <pid> PID for the JVM
#         <cpuUsage> percentage of CPU time being used by the JVM 
#         <physicalMemoryUsage> amount of physical memory (MB) being used by 
#           the JVM
#
#    NOTES
#
#
#    MODIFIED   (MM/DD/YY)
#    bkesavan   12/01/04 - hp specific changes
#    njagathe   10/28/03 - Stop collecting uptime 
#    aaitghez   01/21/03 - change format of call to get process chars
#    klmichae   08/23/02 - klmichae_bug-2519611
#    klmichae   08/23/02 - Initial revision

use strict;

require "iasresourceusage.pl";
require "emdprocesschars.pl";

# Get the pids for the OC4J instance and store them in an array
my $oc4jPids = getOc4jPids( $ARGV[0], $ARGV[1] );
my @pid_array = split( ',', $oc4jPids );


my $platform = $^O;

# get the memory and cpu usage for each pid
# different func call for hp - bug 3921545
if ($platform eq "hpux") {
   foreach my $pid (@pid_array)
   {
     # convert memory for KB to MB
     my $physical_mem = getPhysicalMemoryUsage($pid, 0)/1024.0;
     my $cpu_util = getCPUUtilization($pid, 0);
   
     print "em_result=$pid|$cpu_util|$physical_mem\n";
   }
}
else {
   foreach my $pid (@pid_array)
   {
     # convert memory for KB to MB
     my @result_vec;
     my @stats = ("rss", "pcpu");
     my @file_types;
     my $getFileHandles = 0;
   
     my $physical_mem = 0;
     my $cpu_util = 0;
     
     getProcessChars($getFileHandles, 
   		  0, #don't include children 
   		  $pid, 
   		  \@stats, 
   		  \@result_vec, 
   		  \@file_types);
     
     $physical_mem = @result_vec[0]/1024.0;
     $cpu_util = @result_vec[1];
   
     print "em_result=$pid|$cpu_util|$physical_mem\n";
   }
}
