#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/ocmprop.pm /main/6 2010/08/12 01:43:25 prasawas Exp $
#
# ocmprop.pm
# 
# Copyright (c) 2004, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#     ocmprop.pm
#
#    DESCRIPTION
#     routines to get ocm properties 
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    prasawas  08/02/10 - Adding getConfigPropertyValue which returns the
#                         property value for the specified property name and 
#                         the file used for searching it.
#    pparida   10/29/08 - pparida_ocm_status_metric: Also read state
#                         properties.
#    ndutko    10/10/07 - XbranchMerge ndutko_bug6467738 from st_emll_10.2.7
#    ndutko    10/10/07 - Look in CCR_HOME as well as in CCR_CONFIG_HOME for
#                         property values
#    jsutton   09/04/07 - Expand the set of directories
#    jsutton   07/26/07 - Pick up existing shared OH work
#    jsutton   07/25/07 - Shared home work
#    glavash   12/14/06 - creation
use strict;
use File::Spec;
use File::Basename;

package ocmprop;

require Exporter;

# Mine the configuration files looking in the LiveLink_Root directory
# under the config directory and the default properties are default
# directory.

use constant CONFIG_DIR         => "config";
use constant DEFAULT_CONFIG_DIR => File::Spec->catdir( CONFIG_DIR, "default" );

use constant CCR_CONFIG_ROOT => $ENV{'CCR_CONFIG_HOME'};
use constant CCR_DEFAULT_CONFIG_DIR =>
  File::Spec->catdir( CCR_CONFIG_ROOT, DEFAULT_CONFIG_DIR );
use constant CCR_CONFIG_DIR =>
  File::Spec->catdir( CCR_CONFIG_ROOT, CONFIG_DIR );

use constant LIVELINK_ROOT => $ENV{'CCR_HOME'};
use constant LIVELINK_DEFAULT_CONFIG_DIR =>
  File::Spec->catdir( LIVELINK_ROOT, DEFAULT_CONFIG_DIR );
use constant LIVELINK_CONFIG_DIR =>
  File::Spec->catdir( LIVELINK_ROOT, CONFIG_DIR );


use constant STATE_DIR => "state";
use constant LIVELINK_STATE_DIR => File::Spec->catdir( LIVELINK_ROOT, STATE_DIR );
use constant CCR_STATE_DIR => File::Spec->catdir( CCR_CONFIG_ROOT, STATE_DIR );

@ocmprop::ISA = ('Exporter');
@ocmprop::EXPORT = qw(
                      &getConfigProperties
                      &getConfigPropertyValue
                      &getStateProperties
                     );


# getconfigProperties takes the config filename and trolls thru
# the config files in the CONFIG_DIR and DEFAULT_CONFIG_DIR directories
# and records the entries
#
# it returns an anonymous hashMap that is keyed off of the propertyName.
# the value itself is an anonymous hashmap that contains the VALUE and
# FILENAME where the property was found.
sub getConfigProperties($) 
{
    my $configFile    = shift;
    my $refProperties = {};

    # Order is specific for files specifed. It moves from defaults to user
    # overrides. If elements are found later, they override what is used and
    # also uploaded.

    collectConfigProperties( $refProperties,
        File::Spec->catfile( LIVELINK_DEFAULT_CONFIG_DIR, $configFile ) );

    collectConfigProperties( $refProperties,
        File::Spec->catfile( LIVELINK_CONFIG_DIR, $configFile ) );

    collectConfigProperties( $refProperties,
        File::Spec->catfile( CCR_DEFAULT_CONFIG_DIR, $configFile ) );

    collectConfigProperties( $refProperties,
        File::Spec->catfile( CCR_CONFIG_DIR, $configFile ) );

    return $refProperties;
}

# Subroutine for returning config paths from highest priority to lowest priority.
sub getConfigPathArray($)
{
    my $configFile = shift;
    my @configPathArray = ();
    $configPathArray[0] = File::Spec->catfile( CCR_CONFIG_DIR, $configFile );
    $configPathArray[1] = File::Spec->catfile( CCR_DEFAULT_CONFIG_DIR, $configFile );
    $configPathArray[2] = File::Spec->catfile( LIVELINK_CONFIG_DIR, $configFile );
    $configPathArray[3] = File::Spec->catfile( LIVELINK_DEFAULT_CONFIG_DIR, $configFile );

    return @configPathArray;

}

# Subroutine which takes filename and propertyname as arguments and returns
# the corresponding propertvalue as soon as it is found in config hierarchy.
sub getConfigPropertyValue($$)
{
    my $fileName    = shift;
    my $propertyName  = shift;
    my @searchPathArray = getConfigPathArray($fileName);
    my $searchPath;   
    foreach $searchPath(@searchPathArray)
    {    
    	if ( -f $searchPath )
    	{
        	open CONFIG, "<$searchPath" or die "Unable to open config file";

       		my $line;
        	LINE:
        	
                while ( $line = <CONFIG> )
        	{
            		chomp $line;

                	# Trim off the characters after comment character and any leading whitespace.
                	$line =~ s/^\s*([^#]*).*/$1/;
                	next LINE if ( length($line) == 0 );

                	my ( $property, $value ) = ( $line =~ /\s*(.*?)\s*=\s*(.*)\s*/ );
                	next LINE if ( length($property) == 0 );
        
                	if ($property eq $propertyName)
                	{
            			close CONFIG;
                		# Trimming any leading or trailing whitespaces in value.
                		$value =~ s/^\s+//;
                		$value =~ s/\s+$//;
                		# returning the value as soon as it is found.
                                return $value;
            		}

        	}

           	close CONFIG;
     	}

    }
    # returning NIL if the property name specified is not found in any of the files.
    return '';
}

sub getStateProperties($) 
{
    my $stateFile    = shift;
    my $refProperties = {};

    # Order is specific for files specifed. It moves from defaults to user
    # overrides. If elements are found later, they override what is used and
    # also uploaded.

    collectConfigProperties( $refProperties,
        File::Spec->catfile( LIVELINK_STATE_DIR, $stateFile ) );

    collectConfigProperties( $refProperties,
        File::Spec->catfile( CCR_STATE_DIR, $stateFile ) );

    return $refProperties;
}



sub collectConfigProperties($$) 
{
    my ( $refProperties, $file ) = @_;


    if ( -f $file )
    {
        open CONFIG, "<$file" or die "Unable to open config file";

        my $line;
        LINE:
        while ( $line = <CONFIG> )
        {
            chomp $line;

               # Trim off the characters after comment character and any leading whitespace.
            $line =~ s/^\s*([^#]*).*/$1/;
            next LINE if ( length($line) == 0 );

            my ( $property, $value ) = ( $line =~ /\s*(.*?)\s*=\s*(.*)\s*/ );
            next LINE if ( length($property) == 0 );
            my $refProperty = {
                VALUE    => $value,
                FILENAME => $file
            };
            $refProperties->{$property} = $refProperty;
        }

        close CONFIG;
    }
}
