#!/usr/local/bin/perl
# 
# $Header: calconf.pl 01-oct-2004.16:16:12 cpolinsk Exp $
#
# calconf.pl
# 
# Copyright (c) 2003, 2004, Oracle. All rights reserved.  
#
#    NAME
#      calconf.pl - <one-line expansion of the name>
#
#    AUTHOR
#      Chandrakant Bagade 
#
#    DESCRIPTION
#      Script reads calendar config data
#
#    MODIFIED   (MM/DD/YY)
#       cpolinsk 10/01/04 - cpolinsk_1001_policy
# 

use strict;

my $OSNAME = $^O;
my $propertyFileName = "";

# opening  $ORACLE_HOME/ocal/misc/unison.ini
if(  ($OSNAME eq "MSWin32") or ($OSNAME eq "Windows_NT") )
{
    $propertyFileName = " $ARGV[0]\\ocal\\misc\\unison.ini";

}
else
{
    $propertyFileName = "$ARGV[0]/ocal/misc/unison.ini";
}


if (!open (PROPFILE,$propertyFileName))
{ 
    print "em_result=||||\n";
    exit 0;
}

# Walk through all the lines looking for the numconnect
#      em_result=numconnect

my $logdebug = "FALSE";
my $numconnect = "";
my $name;
my $value;
my $nothing;

while(<PROPFILE>)
{
    # split apart the name and value.  Then, pull off the new line
    ($name, $value) = split(/=/, $_);

    if( defined( $value ) )
    {
        ($value, $nothing) = split("\n", $value);
    }
  
    # Pull off the properties that we are interested in
    $name  =~ s/^\s//;
    $name  =~ s/\s$//;
    $value =~ s/^\s//;
    $value =~ s/\s$//;


    if($name eq "log_debug")
    {
        $logdebug=$value;
    }

    if($name eq "numconnect")
    {
        $numconnect=$value;
    }

}

close(PROPFILE);

print "em_result=$logdebug|$numconnect\n";
