#!/usr/local/bin/perl
# 
# $Header: dbresp.pl 16-oct-2003.21:17:44 tjaiswal Exp $
#
# dbresp.pl
# 
# Copyright (c) 2003, Oracle Corporation.  All rights reserved.  
#
#    NAME
#      dbresp.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    tjaiswal    10/16/03 - tjaiswal_ocs_comp_bugs 
#    tjaiswal    10/15/03 - Creation
# 

use strict;
use Oraperl;
use Time::HiRes;

require "emd_common.pl";

my $db_connect = $ENV{EM_TARGET_USERNAME} . "/" . $ENV{EM_TARGET_PASSWORD} . "@" . $ENV{EM_TARGET_ADDRESS};

my $start_time = Time::HiRes::time;

my $lda;
unless ( $lda = &ora_login ('', $db_connect, '') )
{ 
  if( index($ora_errstr, "01017",0)!=-1)
  {
    die "$ora_errstr\n";
  }
  else
  {
    print "em_result=|0|$ora_errstr\n";
  }
  exit 0; 
}

register_metric_call($lda);

my $end_time = Time::HiRes::time;

&ora_logoff($lda) || warn "ora_logoff($lda): $ora_errno: $ora_errstr\n";

# the end_time and start_time returned are in terms of seconds, 
# the logon_time should be in miliseconds
my $logon_time = ($end_time - $start_time) * 1000;

print "em_result=$logon_time|1|\n";

exit 0;

