#!/usr/local/bin/perl
# 
# $Header: email_comp_assoc.pl 10-apr-2007.10:15:25 ndutko Exp $
#
# email_comp_assoc.pl
# 
# Copyright (c) 2006, 2007, Oracle. All rights reserved.  
#
#    NAME
#      email_comp_assoc.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    ndutko      04/10/07 - Movement of esemconfig from CCR_HOME/lib to
#                           CCR_HOME/sysman/admin/lib
#    rayleung    02/14/06 - perl script for collecting email comp assoc data 
#                           in Livelink 
#    rayleung    02/14/06 - Creation
#

# association types are defined in ecmassoc.pm
use ecmAssoc;
# set up to accept user input
use Getopt::Long;

my $OSNAME = $^O;
my $cmd = "";
my $l_oracle_home;
my $l_midtier_host;
my $l_target_type;

# email targets associate parameters
GetOptions(
            "OracleHome=s" => \$l_oracle_home,
            "midtier_host=s" => \$l_midtier_host,
            "targettype=s" => \$l_target_type);

# assoc resutls
my @email_assoc_results;

# email middle tier target association
if($l_target_type eq "email")
{
    push(@email_assoc_results, "em_result=".$ecmAssoc::CONTAINS."||imap|".$l_midtier_host.":".$l_oracle_home."\n");
    push(@email_assoc_results, "em_result=".$ecmAssoc::CONTAINS."||smtp_in|".$l_midtier_host.":".$l_oracle_home."\n");
    push(@email_assoc_results, "em_result=".$ecmAssoc::CONTAINS."||smtp_out|".$l_midtier_host.":".$l_oracle_home."\n");
    push(@email_assoc_results, "em_result=".$ecmAssoc::CONTAINS."||nntp_in|".$l_midtier_host.":".$l_oracle_home."\n");
    push(@email_assoc_results, "em_result=".$ecmAssoc::CONTAINS."||nntp_out|".$l_midtier_host.":".$l_oracle_home."\n");
    push(@email_assoc_results, "em_result=".$ecmAssoc::CONTAINS."||pop|".$l_midtier_host.":".$l_oracle_home."\n");
    push(@email_assoc_results, "em_result=".$ecmAssoc::CONTAINS."||housekeeper|".$l_midtier_host.":".$l_oracle_home."\n");
    push(@email_assoc_results, "em_result=".$ecmAssoc::CONTAINS."||slist|".$l_midtier_host.":".$l_oracle_home."\n");
    push(@email_assoc_results, "em_result=".$ecmAssoc::CONTAINS."||vscrub|".$l_midtier_host.":".$l_oracle_home."\n");
}
# other email targets (IMAP, SMTP, etc.) association
else
{
    # parameters for oracle_database association
    $db_params = "aparam=x121address,orclmailstoreport,orclmailstoresid";

    # construct the oracle_database/mailstore association command
    if(($OSNAME eq "MSWin32") or ($OSNAME eq "Windows_NT"))
    {
        $cmd="$l_oracle_home\\jdk\\bin\\java -classpath $l_oracle_home\\jlib\\repository.jar:$l_oracle_home\\ccr\\sysman\\admin\\lib\\esemconfig.jar:$l_oracle_home\\jlib\\esemconfig.jar oracle.mail.admin.emconfig.EmailAssocData $l_oracle_home $l_midtier_host $l_target_type $db_params";
    }
    else
    {
        $cmd="$l_oracle_home/jdk/bin/java -classpath $l_oracle_home/jlib/repository.jar:$l_oracle_home/ccr/sysman/admin/lib/esemconfig.jar:$l_oracle_home/jlib/esemconfig.jar oracle.mail.admin.emconfig.EmailAssocData $l_oracle_home $l_midtier_host $l_target_type $db_params";
    }

    # exec the command
    my @results = `$cmd`;

    # get the associate result
    foreach $result (@results)
    {
        chomp $result;

        # if any em_error happens, we will skip the collection for the particular association 
        #  and continue the next collection
        if (index ($result, "assoc_result" ) != -1)
        {
            $result =~ s#assoc_result=##g;
            push(@email_assoc_results, "em_result=".$ecmAssoc::CONNECTS_TO."||".$ecmAssoc::ORACLE_DATABASE_TYPE."|".$result."\n");
            push(@email_assoc_results, "em_result=".$ecmAssoc::CONNECTS_TO."||mailstore|".$result."\n");
        }
        elsif (index ($result, "em_error") != -1)
        {
            push(@email_assoc_resutls, $result);
        }
    }

    # constrcut the oracle_lintener association command for imap, smtp_in, nntp_in, and pop targets
    if (($l_target_type eq "imap") or ($l_target_type eq "smtp_in") or ($l_target_type eq "nntp_in") or ($l_target_type eq "pop"))
    {
        push(@email_assoc_results, "em_result=".$ecmAssoc::CONNECTS_TO."||".$ecmAssoc::LISTENER_TYPE."|".$l_midtier_host.":".$l_oracle_home."\n");
    }
}

# collect the ldap target info
my $ldap_oh = $l_oracle_home;
my $ias_file = "/config/ias.properties";
my $full_path;
my $ldap_host;
my $ldap_port;
my $ldap_ssl_port;
my $ldap_ssl;

chomp $conn_descriptor;
chomp $ldap_oh;

#get the complete path for file "ias.properties" 
if(($OSNAME eq "MSWin32") or ($OSNAME eq "Windows_NT"))
{
    $ias_file =~ s/\//\\/g;
}
$full_path = $ldap_oh . $ias_file;

# check to see if ias.properties exists
if ( -e $full_path )
{
    # get the OID host and port info
    open( CONFFILE, $full_path );
    while( <CONFFILE> )
    {
        my $current_property = $_;

        # trim the leading and trailing spaces
        chomp( $current_property );
        $current_property  =~ s#^\s+|\s+$##g;

        my $property_name;

        if( $current_property =~ /^OIDhost/ )
        {
            ( $property_name, $ldap_host ) = split /=/, $current_property, 2;
            chomp ( $ldap_host );
        }
        elsif( $current_property =~ /^OIDport/ )
        {
            ( $property_name, $ldap_port ) = split /=/, $current_property, 2;
            chomp ( $ldap_port );
        }
        elsif( $current_property =~ /^OIDsslport/ )
        {
            ( $property_name, $ldap_ssl_port ) = split /=/, $current_property, 2;
            chomp ( $ldap_ssl_port );
        }
        elsif ( $current_property =~ /^SSLOnly/ )
        {
            ( $property_name, $ldap_ssl ) = split /=/, $current_property, 2;
            chomp ( $ldap_ssl );
        }
    }
    close( CONFFILE );

    # returns the OID connect descriptor, host, port and ssl port
    push(@email_assoc_results, "em_result=".$ecmAssoc::CONNECTS_TO."||".$ecmAssoc::ORACLE_LDAP_TYPE."|".$ldap_host.":".$ldap_port.":".$ldap_ssl_port."\n");
}
else
{
    push(@mail_assoc_results, "em_error=Cannot open file \"".$full_path."\"\n");
}

# print out all the association targets and its properties
foreach $result (@email_assoc_results)
{
    print $result;
}

exit 0;
