#!/usr/local/bin/perl
# 
# $Header: email_comp_config.pl 10-apr-2007.10:15:25 ndutko Exp $
#
# email_comp_config.pl
# 
# Copyright (c) 2006, 2007, Oracle. All rights reserved.  
#
#    NAME
#      email_comp_config.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    ndutko      04/10/07 - Movement of esemconfig from CCR_HOME/lib to
#                           CCR_HOME/sysman/admin/lib
#    rayleung    02/14/06 - perl script for collecting email comp config data 
#                           for Livelink 
#    rayleung    02/14/06 - Creation
#

# set up to accept user input
use Getopt::Long;

my $OSNAME = $^O;
my $cmd = "";
my $l_oracle_home;
my $l_midtier_host;
my $l_target_type;
my $l_config_scope;

# ocs component config parameters
GetOptions(
            "OracleHome=s" => \$l_oracle_home,
            "midtier_host=s" => \$l_midtier_host,
            "targettype=s" => \$l_target_type,
            "scope=s" => \$l_config_scope);

if(($OSNAME eq "MSWin32") or ($OSNAME eq "Windows_NT"))
{
    $cmd="$l_oracle_home\\jdk\\bin\\java -classpath $l_oracle_home\\jlib\\repository.jar:$l_oracle_home\\jlib\\esemconfig.jar:$l_oracle_home\\ccr\\sysman\\admin\\lib\\esemconfig.jar oracle.mail.admin.emconfig.EmailConfigData $l_oracle_home $l_midtier_host $l_target_type $l_config_scope";
}
else
{
    $cmd="$l_oracle_home/jdk/bin/java -classpath $l_oracle_home/jlib/repository.jar:$l_oracle_home/ccr/sysman/admin/lib/esemconfig.jar:$l_oracle_home/jlib/esemconfig.jar oracle.mail.admin.emconfig.EmailConfigData $l_oracle_home $l_midtier_host $l_target_type $l_config_scope";
}

my @results = `$cmd`;

#printing result
foreach $result ( @results )
{
    chomp $result;

    # print those strings only start with em_result or em_error 
    if( (index( $result, "em_result=" ) != -1) or (index( $result, "em_error=" ) != -1) )
    {
        print $result."\n";
    }
}

exit 0;
