# $Header: email_stat.pl 29-jul-2005.02:19:19 pallumpa Exp $
#
# email_stat.pl
#
# Copyright (c) 2004, 2005, Oracle. All rights reserved.  
#
#    NAME
#      email_stat.pl
#
#    DESCRIPTION
#       The email service is considered to be up if any of the email processes are running
#       The OS command to use for this is:
#       for solaris: ps -ef | grep $proc_name | grep -v 'grep $proc_name'
#       for linux: /usr/ucb/ps -auxww | grep $proc_name | grep -v 'grep $proc_name'
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    pallumpa   07/29/05 - Fix 4519421 - Fix porting issues 
#    jkrishna   07/12/04 - jkrishna_grid_metadata
#    jkrishna   07/05/04 - Creation 
#

my $OSNAME = $^O;
my $proc_name;
my $proc_num = 0;
# the process name is the same irrespective of the platform
@procs = ("esimapds", "essmi", "essmo", "esnni", "esnno", "esls", "esvs", "esgc", "espop3ds");

print "OS: $OSNAME \n";

if( ($OSNAME eq "solaris") || ($OSNAME eq "sunos") )
{
    foreach $proc_name(@procs)
    {
      print "Process name: $proc_name \n";
      chomp ($proc_num = `ps -ef | grep $proc_name | grep -v 'grep $proc_name'|wc -l`);
      if( $proc_num > 0 ) {
        $email_proc_num++;
      }
    }
}
elsif( $OSNAME eq "hpux" )
{
    foreach $proc_name(@procs)
    {
      chomp ($proc_num = `ps -ef | grep $proc_name | grep -v 'grep $proc_name'|wc -l`);
      if( $proc_num > 0 ) {
        $email_proc_num++;
      }
    }

}
elsif( $OSNAME eq "aix" )
{
    foreach $proc_name(@procs)
    {
      chomp ($proc_num = `ps -ef | grep $proc_name | grep -v 'grep $proc_name'|wc -l`);
      if( $proc_num > 0 ) {
        $email_proc_num++;
      }
    }

}
elsif( $OSNAME eq "dec_osf" )
{
    foreach $proc_name(@procs)
    {
      chomp ($proc_num = `ps -ef | grep $proc_name | grep -v 'grep $proc_name'|wc -l`);
      if( $proc_num > 0 ) {
        $email_proc_num++;
      }
    }

}
elsif( $OSNAME eq "linux" or $OSNAME eq "darwin" )
{
    foreach $proc_name(@procs)
    {
      chomp ($proc_num = `/bin/ps -auxww | grep $proc_name | grep -v 'grep $proc_name'|wc -l`);
      if( $proc_num > 0 ) {
        $email_proc_num++;
      }
    }
}
elsif( ($OSNAME eq "MSWin32") or ($OSNAME eq "Windows_NT") )
{
    # for windows, nmupm TopProcs is used to get the process info
    my @e_procs = `$ENV{EMDROOT}/bin/nmupm TopProcs`;

    foreach $e_process ( @e_procs ) 
    {
        # chomp first;
        chomp( $e_process );
        
        # note that e_process is of the form: em_result=2340|nmesrvc|N/A|0.12|0.00|1300|280|0
        # the second value is the process name and is of interest
        # split based on "|"
        my @allValues = split( /\|/, $e_process );
        my $secondValue = @allValues[1];

        # do an ignore case compare of the process name with each of the email processes
        foreach $proc_name(@procs)
        {
          if( lc($secondValue) eq $proc_name )
          {
            $email_proc_num++;
          }
        }
        
        chomp( $email_proc_num );
    }
}
else
{
    die "em_error=Unsupported operating system\n";    
}

#
# if the number of running email proceses is above zero, it means email is running
#
if( $email_proc_num > 0 ) { 
    print "em_result=1\n";
} else {
    print "em_result=0\n";
} 

