#!/usr/local/bin/perl
# 
# $Header: get_email_version.pl 07-nov-2005.05:52:28 pallumpa Exp $
#
# get_email_version.pl
# 
# Copyright (c) 2005, Oracle. All rights reserved.  
#
#    NAME
#      get_email_version.pl - returns the version of the email component
#                              or patch installed.
#
#    DESCRIPTION
#      Script calls EMVersionFetch and returns the version
#      of the email component or last patch installed.
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    pallumpa    09/28/05 - Creation
#
#
require "emd_common.pl";

my $oh = $ENV{EM_ORCL_HOME};
my $agent_oh = $ENV{ORACLE_HOME};
my $debug = $ENV{EM_DEBUG_FLAG};

my $filesep,$pathsep;
if ( $ENV{OS} =~ /^Windows/ ) 
{
    $filesep = "\\";
    $pathsep = ";";
} else {
    $filesep = "/";
    $pathsep = ":";
}

my $java = join($filesep, $oh, "jdk", "jre", "bin", "java");

my $ouijlib = "${oh}${filesep}oui${filesep}jlib${filesep}";

my @ouijarfiles = ("${ouijlib}OraInstaller.jar",
                "${ouijlib}share.jar",
                "${ouijlib}srvm.jar",
                "${ouijlib}xmlparserv2.jar");
my $ouiclasspath = join ($pathsep, @ouijarfiles);

my $utilcp = "${agent_oh}${filesep}sysman${filesep}jlib${filesep}esemutil.jar${pathsep}${oh}${filesep}jlib${filesep}esemutil.jar";
                
my $command = "$java -DOracleMailHome=$oh -DDEBUG=$debug  -classpath ${utilcp}${pathsep}${ouiclasspath} oracle.mail.admin.emutil.EMVersionFetch";

@command_res = system $command;

if ($? > 0 )
{
  EMD_PERL_DEBUG("The following command failed : $command. Error Code : $?");
  err_exit("The following command failed : $command. Error Code : $?");
}
else
{
  foreach (@command_res)
  {
    if ( /em_result/ )
    {
      print "$_";
    }
    else
    {
      EMD_PERL_DEBUG("$_");
    }
  }
  
}
exit 0;

sub err_exit
{
   my ($exit_error_msg) = @_;
   print "em_error=$exit_error_msg\n";
   print "em_result=0\n";
   exit 0;
}

