#!/usr/local/bin/perl
# 
# $Header: imap_service_stat.pl 18-jun-2004.07:51:29 jkrishna Exp $
#
# imap_service_stat.pl
#  
# Desc : the IMAP service target should be marked as down only if the "connection"
#        and "login" to the IMAP service fails 6 consecutive times ( or a user
#        specifiable property ). The initial version will not let the user to 
#        configure the number of times a failure can be allowed for concerns on
#        using large number. 
# 
# Copyright (c) 2003, 2004, Oracle. All rights reserved.  
#
#    NAME
#      imap_service_stat.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    jkrishna    06/18/04 - jkrishna_gridctrl_040609
#    jkrishna    06/17/04 - ocs 9.0.5 grid control
#    hwjung	 10/25/03 - Bug3206136 - down only if fails 6 consecutive times 
#    gmulchan    07/30/03 - gmulchan_ocsv1_main_merge
#    tjaiswal    04/25/03 - 
#    tjaiswal    04/22/03 - 
#    tjaiswal    04/20/03 - Creation
# 
#use strict;
use Net::IMAP::SimpleConn;
use Time::HiRes;

#imap parameters
$imap_host=$ENV{EM_IMAP_HOST};
$imap_port=$ENV{EM_IMAP_PORT};
$imap_username=$ENV{EM_IMAP_ID};
$imap_password=$ENV{EM_IMAP_PASSWORD};
# hwjung: add
# get fail_count , default value is 6 times
$imap_fail_count=6;

# metrics
######
# $connect_time
# $login_time
# $open_email_time
# $list_folders_time
####

print "Connecting.. $imap_host:$imap_port :: $imap_username\n";

# open a connection to the IMAP server

$start_time = Time::HiRes::time();
# the number of failed login try 
$fail_count = 0;

do {
   $status = check_imap_login();
   $fail_count++;
   print "test count = $fail_count, statst = $status\n";
}while ( $fail_count < $imap_fail_count && $status == 0 );

if ( $status == 1 ) {
   print "Connect Time = $connect_time\n";
   print "Login Time = $login_time\n";
   print "List Folders Time = $list_folders_time\n";
   print "Open Email Time = $open_email_time\n";
   print "Total Time = $total_time\n";
   printf ("em_result=%d|%.2f|%.2f|%.2f|%.2f|%.2f\n", $status, $total_time,
          $connect_time, $login_time, $open_email_time, $list_folders_time);
#   print "em_result=$status\n";        
} else {
   print "em_result=$status\n";
}
   
#################################################################
# create sub routine
# return value : 1 - login success
#                0 - login fail
#################################################################
sub check_imap_login {
   # define $l_status as local variable
   my( $l_status );    

   # connect imap server
   $server = Net::IMAP::SimpleConn->new( $imap_host, $imap_port);

   # if connection is succeed
   if ($server) 
   {
       $l_status = 1;
       $connect_time = Time::HiRes::time() - $start_time;
   
       # login, by default selects INBOX
       $start_time = Time::HiRes::time();

       $num_messages = $server->login( $imap_username, $imap_password );
       print "Number of messages in the inbox = $num_messages\n";
       $login_time = Time::HiRes::time() - $start_time;

       # decide if this is a metric error or just l_status = down ?
       if (! defined  ($num_messages))
       {
           # regard this as l_status down
           print "Login failed\n";
           $l_status = 0;
       } else {
          # Read the first message
          $start_time = Time::HiRes::time();
          $lines = $server->get( 1 );
          $open_email_time = Time::HiRes::time() - $start_time;
   
          # the list of all folders
          $start_time = Time::HiRes::time();
          @folders = $server->mailboxes();
          for ($i=0; $i < @folders; $i++)
          { 
              #print "$folders[$i]\n";
          }
          $list_folders_time = Time::HiRes::time() - $start_time;
      
          # close the connection
          $server->quit();
   
          $total_time = $connect_time + $login_time + $open_email_time + 
          $list_folders_time;
   
          # Important : Convert to milliseconds.
          $connect_time = toMilliSec($connect_time) ;
          $login_time = toMilliSec($login_time);
          $list_folders_time = toMilliSec($list_folders_time) ;
          $open_email_time = toMilliSec($open_email_time) ;   
          $total_time = toMilliSec($total_time); 
      
      } # end of login fail
   } 
   else 
   {   # fail to connect imap
      print "Connection failed\n";
      $l_status = 0;
   }

   return $l_status
} # end of check_imap_login

sub toMilliSec 
{
    my ( $time_in_sec) = @_;
    return $time_in_sec * 1000;
}

