# $Header: imap_stat.pl 29-jul-2005.02:19:21 pallumpa Exp $
#
# imap_stat.pl
#
# Copyright (c) 2001, 2005, Oracle. All rights reserved.  
#
#    NAME
#      imap_stat.pl
#
#    DESCRIPTION
#       The IMAP server should be marked as down if there is no $proc_name process
#       talking to this IMAP server as obtained from a "ps" command.
#       The OS command to use for this is:
#       for solaris: ps -ef | grep $proc_name | grep -v 'grep $proc_name'
#       for linux: /usr/ucb/ps -auxww | grep $proc_name | grep -v 'grep $proc_name'
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    pallumpa   07/29/05 - Fix 4519421 - Fix porting issues 
#    jkrishna   01/12/05 - Fix bug #4048084
#    jkrishna   06/18/04 - jkrishna_gridctrl_040609
#    jkrishna   05/28/04 - jkrishna_oes_grid_control
#    jkrishna   05/25/04 - OCS v2.1   
#    tjaiswal   02/12/04 - Bug 3432641 
#    tjaiswal   11/11/03 - tjaiswal_bug-3206136 
#    hwjung     10/25/03 - Creation - Bug3206136
#

use Net::IMAP::SimpleConn;
use Time::HiRes;

my $OSNAME = $^O;

# The following is for backward compatibility with 10.1.0.3
#
# To determine the status value
# if( OracleHome is not available )
#   Ping via IMAP protocol; EM 10.1.0.3 style
# else
#   do ps -ef or equivalent; EM 10.1.0.4 style
# endif

$imap_host=$ENV{EM_IMAP_HOST};
$imap_port=$ENV{EM_IMAP_PORT};

# OCS 10.1.1 and above
# To be used for multiple Oracle Home support
$orcl_home=$ENV{EM_ORCL_HOME};

# The Oracle Home will not be passed from a 10.1.0.3 agent
# Because it is a 10.1.0.4 property

unless( $orcl_home )
{                
 # printf( "Oracle Home is %s\n", $orcl_home);

  if( $imap_host) 
  {
    #printf( "Connecting\n");
    $server = Net::IMAP::SimpleConn->new($imap_host, $imap_port);
  }

  if ($server) 
  {
    #printf( "Connected\n");

    $server->quit();
    $status = 1;

    #printf( "Disconnected\n");
  }
  else
  {
    $status = 0;
  }

  printf ("em_result=%d\n", $status);

  #printf("Exiting");
  exit;
}


# Check if the IMAP process is running

# the process name is the same irrespective of the platform
$proc_name = "esimapds";

print "OS: $OSNAME \n";
print "Process name: $proc_name \n";

if( ($OSNAME eq "solaris") || ($OSNAME eq "sunos") )
{
    chomp ($imap_proc_num = `ps -ef | grep $proc_name | grep -v 'grep $proc_name'|wc -l`);
}
elsif( $OSNAME eq "hpux" )
{
    chomp ($imap_proc_num = `ps -ef | grep $proc_name | grep -v 'grep $proc_name'|wc -l`);
}
elsif( $OSNAME eq "aix" )
{
    chomp ($imap_proc_num = `ps -ef | grep $proc_name | grep -v 'grep $proc_name'|wc -l`);
}
elsif( $OSNAME eq "dec_osf" )
{
    chomp ($imap_proc_num = `ps -ef | grep $proc_name | grep -v 'grep $proc_name'|wc -l`);
}
elsif( $OSNAME eq "linux" or $OSNAME eq "darwin")
{
    chomp ($imap_proc_num = `/bin/ps -auxww | grep $proc_name | grep -v 'grep $proc_name'|wc -l`);
}
elsif( ($OSNAME eq "MSWin32") or ($OSNAME eq "Windows_NT") )
{
    # for windows, nmupm TopProcs is used to get the process info
    my @e_processes = `$ENV{EMDROOT}/bin/nmupm TopProcs`;

    foreach $e_process ( @e_processes ) 
    {
        # chomp first;
        chomp( $e_process );
        
        # note that e_process is of the form: em_result=2340|nmesrvc|N/A|0.12|0.00|1300|280|0
        # the second value is the process name and is of interest
        # split based on "|"
        my @allValues = split( /\|/, $e_process );
        my $secondValue = @allValues[1];
        # do an ignore case compare of the process name
        if( lc($secondValue) eq $proc_name )
        {
            $imap_proc_num++;
        }
        
        chomp( $imap_proc_num );
    }
}
else
{
    die "em_error=Unsupported Operating System\n";    
}

#
# if the number of $proc_name process is above then zero, it means imap is running
# else imap is die
#
if( $imap_proc_num > 0 ) { 
    print "em_result=1\n";
} else {
    print "em_result=0\n";

} 

