
#use strict;
$oraHome=$ENV{ORACLE_HOME};
$webconf_oh=$ENV{EM_CLIENTOH};
$webconf_dir=$ENV{EM_DIR};
$rtcVer=$ENV{RTC_VER};
$tmpDir=$ENV{TEMP};

require "emd_common.pl";

require "ocs/iasresourceusageforimeeting.pl";

if (($^O =~ "Windows") || ($^O =~ "MSWin32"))  # windows platforms
{
    $TMPFILE = "$tmpDir/webconfProcInfo.out";
    getResourceUsageForNT();
    exit;
}

if ($rtcVer eq "9.0.4") 
{
    if ( $^O eq "linux" )
    {
	open(INFILE, "/bin/ps auxww | grep imt-collab | grep -v grep |");
    }
    elsif ( $^O eq "hpux" )
    {
    	open(INFILE, "/bin/ps -efx | grep imt-collab | grep -v grep |");
    }
    else
    {
	open(INFILE, "/usr/ucb/ps -wwwaux | grep imt-collab | grep -v grep |");
    }
    #$dummy = <INFILE>;
    while (<INFILE>)
    {
        chop;
        @fields = split(/ +/);
        $pid = $fields[1];
        $pname = $fields[$#fields];
        $pname =~ s/.*.imt-collab/imt-collab/;
        if ($parray1{$pname}) {
            $parray1{$pname} = "$parray1{$pname}, $pid";
        } else {
            $parray1{$pname} = $pid;
        }
    }

    while (($key, $value) = each %parray1) {
        @pids = split(/,/,$value);
        getResourceUsage($ARGV[0], $ARGV[1], $value, \@pids, $key);
    }
}

if ($rtcVer eq "9.0.5")
{
    if ( $^O eq "linux" )
    {
        open(INFILE, "/bin/ps auxww | grep rtc-confsvr | grep -v grep |");
    }
    elsif ( $^O eq "hpux" )
    {
        open(INFILE, "/bin/ps -efx | grep rtc-confsvr | grep -v grep |");
    }
    else
    {
        open(INFILE, "/usr/ucb/ps -wwwaux | grep rtc-confsvr | grep -v grep |");
    }
    #$dummy = <INFILE>;
    while (<INFILE>)
    {
        chop;
        @fields = split(/ +/);
        $pid = $fields[1];
        $pname = $fields[$#fields];
        $pname =~ s/.*.rtc-confsvr/rtc-confsvr/;
        if ($parray2{$pname}) {
            $parray2{$pname} = "$parray2{$pname}, $pid";
        } else {
            $parray2{$pname} = $pid;
        }
    }

    while (($key, $value) = each %parray2) {
        @pids = split(/,/,$value);
        getResourceUsage($ARGV[0], $ARGV[1], $value, \@pids, $key);
    }
}

if ($rtcVer eq "9.0.5")
{
    if ( $^O eq "linux" )
    {
        open(INFILE, "/bin/ps auxww | grep redirect | grep -v grep |");
    }
    elsif ( $^O eq "hpux" )
    {
        open(INFILE, "/bin/ps -efx | grep redirect | grep -v grep |");
    }
    else
    {
        open(INFILE, "/usr/ucb/ps -wwwaux | grep redirect | grep -v grep |");
    }
    #$dummy = <INFILE>;
    while (<INFILE>)
    {
        chop;
        @fields = split(/ +/);
        $pid = $fields[1];
        $pname = "redirect";
        if ($parray7{$pname}) {
            $parray7{$pname} = "$parray7{$pname}, $pid";
        } else {
            $parray7{$pname} = $pid;
        }
    }

    while (($key, $value) = each %parray7) {
        @pids = split(/,/,$value);
        getResourceUsage($ARGV[0], $ARGV[1], $value, \@pids, $key);
    }
}

if ( $^O eq "linux" )
{
        open(INFILE, "/bin/ps auxww |  grep bin/mx | grep -v grep |");
}
elsif ( $^O eq "hpux" )
{
        open(INFILE, "/bin/ps -efx | grep bin/mx | grep -v grep |");
}
else
{
        open(INFILE, "/usr/ucb/ps -wwwaux | grep bin/mx | grep -v grep |");
}
while (<INFILE>)
{
    chop;
    @fields = split(/ +/);
    $pid = $fields[1];
    if ($rtcVer eq "9.0.4")
    {
        EMD_PERL_DEBUG("Getting mx info for version $rtcVer");
        $match_idx = -1;
        for ($i = 0; $i < @fields; $i++) {
           #print "I: $i; field: $fields[$i]";
           #print $fields[$i];
           #print "   ";
           $x = index($fields[$i], "bin/mx");
           if ($x != -1) {
              #print "\nindex is $x\n\n";
              $match_idx = $i;
              last;
           }
        }
        #$pname = $fields[$#fields];
        #print "$pname\n match_idx is $match_idx\n";
        #@pnameFields = split(/ +/,$pname);
        $pname = "mx-" . $fields[$match_idx + 2];
    }
    elsif ($rtcVer eq "9.0.5")
    {
        $pname = "mx";
    }

    if ($parray3{$pname}) {
        $parray3{$pname} = "$parray3{$pname}, $pid";
    } else {
        $parray3{$pname} = $pid;
    }
}

while (($key, $value) = each %parray3) {
    @pids = split(/,/,$value);
    getResourceUsage($ARGV[0], $ARGV[1], $value, \@pids, $key);
}

if ($rtcVer eq "9.0.5")
{
    if ( $^O eq "linux" )
    {
        open(INFILE, "/bin/ps auxww | grep ImtPM | grep -v grep |");
    }
    elsif ( $^O eq "hpux" )
    {
        open(INFILE, "/bin/ps -efx | grep ImtPM | grep -v grep |");
    }
    else
    {
        open(INFILE, "/usr/ucb/ps -wwwaux | grep ImtPM | grep -v grep |");
    }
    #$dummy = <INFILE>;
    while (<INFILE>)
    {
        chop;
        @fields = split(/ +/);
        $pid = $fields[1];
        $pname = $fields[$#fields];
        $pname =~ s/.*.ImtPM/ImtPM/;
        if ($parray4{$pname}) {
            $parray4{$pname} = "$parray4{$pname}, $pid";
        } else {
            $parray4{$pname} = $pid;
        }
    }

    while (($key, $value) = each %parray4) {
        @pids = split(/,/,$value);
        getResourceUsage($ARGV[0], $ARGV[1], $value, \@pids, $key);
    }
}

if ($rtcVer eq "9.0.5")
{
    if ( $^O eq "linux" )
    {
        open(INFILE, "/bin/ps auxww | grep jabber.xml | grep -v grep |");
    }
    elsif ( $^O eq "hpux" )
    {
        open(INFILE, "/bin/ps -efx | grep jabber.xml | grep -v grep |");
    }
    else
    {
        open(INFILE, "/usr/ucb/ps -wwwaux | grep jabber.xml | grep -v grep |");
    }
    #$dummy = <INFILE>;
    while (<INFILE>)
    {
        chop;
        @fields = split(/ +/);
        $pid = $fields[1];
        $pname = "im-router-main";
        if ($parray5{$pname}) {
            $parray5{$pname} = "$parray5{$pname}, $pid";
        } else {
            $parray5{$pname} = $pid;
        }
    }

    while (($key, $value) = each %parray5) {
        @pids = split(/,/,$value);
        getResourceUsage($ARGV[0], $ARGV[1], $value, \@pids, $key);
    }
}

if ($rtcVer eq "9.0.5")
{
    if ( $^O eq "linux" )
    {
        open(INFILE, "/bin/ps auxww | grep cm.xml | grep -v grep |");
    }
    elsif ( $^O eq "hpux" )
    {
        open(INFILE, "/bin/ps -efx | grep cm.xml | grep -v grep |");
    }
    else
    {
        open(INFILE, "/usr/ucb/ps -wwwaux | grep cm.xml | grep -v grep |");
    }
    #$dummy = <INFILE>;
    while (<INFILE>)
    {
        chop;
        @fields = split(/ +/);
        $pid = $fields[1];
        $pname = "cm";
        if ($parray6{$pname}) {
            $parray6{$pname} = "$parray6{$pname}, $pid";
        } else {
            $parray6{$pname} = $pid;
        }
    }

    while (($key, $value) = each %parray6) {
        @pids = split(/,/,$value);
        getResourceUsage($ARGV[0], $ARGV[1], $value, \@pids, $key);
    }
}

sub getResourceUsageForNT {
    if ($webconf_dir eq "") {
        $webconf_dir = "imeeting";
    }

    $command = $webconf_oh."/".$webconf_dir."/bin/imtctl getpids > $TMPFILE 2>&1";

    $rc = system($command);

    unless ( open(WCOUT, $TMPFILE) )
        {
                print "em_error=Not able to open $TMPFILE file\n";
                $status = 0;
                print "em_result=$status";
                exit 0;
        }

        my %pidhash;

        if ($rtcVer eq "9.0.4") {
            $rtc_dir = $rtc_dir = $webconf_oh."/".$webconf_dir."/tmp/imtpm";
        }
        else {
            $rtc_dir = $rtc_dir = $webconf_oh."/".$webconf_dir."/tmp/rtcpm";
        }
        $rtc_dir =~ s#/#\\#g;

        for ( `dir /B $rtc_dir` ){
                chomp;
                s/^\s+|\s+$//g;
                next unless $_;
                my @values = split/\./,$_;
                if (@values > 7) {
                    $pidhash{$values[1]} = $values[7];
                }
                else {
                    $pidhash{$values[2]} = 0;
                }
        }

        my %imtProcHasp;
        while (<WCOUT>) {
                chomp;
                s/^\s+|\s+$//g;
                next unless $_;

                my @cols = split/\s+/,$_;

                if ( $cols[3] and exists $pidhash{$cols[3]} ) {
                    $imtProcHash{"$cols[1].$pidhash{$cols[3]}"} = $cols[3];
                }
        }

        foreach $key ( keys %imtProcHash) {

                        my $results = `$oraHome/bin/nmupm.exe procinfo $imtProcHash{$key}`;
                        chomp $results;
                        $results =~ s/^\s+|\s+$//g;
                        next unless $results and $results =~ /em_result/;
                        my @values = split/\|/,$results;
                        print "em_result=$key|$values[1]|$values[2]|$values[3]|$values[4]\n";
        }

}

