#!/usr/local/bin/perl
# 
# $Header: ldap_assoc.pl 15-feb-2006.10:09:35 rayleung Exp $
#
# ldap_assoc.pl
# 
# Copyright (c) 2006, Oracle. All rights reserved.  
#
#    NAME
#      ldap_assoc.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    rayleung    02/15/06 - construct the association with other targets 
#    rayleung    02/15/06 - Creation
# 

use ecmAssoc;
use Getopt::Long; # set up to accept user input

my $OSNAME = $^O;
my $cmd = "";
my $l_conn_desc = "";

#ocs component associate parameters
GetOptions(
            "conn_descriptor=s" => \$l_conn_desc );

my $db_result;
my $rac_result;
my $host;
my $port;
my $service_name;

#parse the connector descriptor
if ((($host, $port, $service_name) = ($l_conn_desc =~ /\s*.*?HOST=(.*?)\)\(PORT=(.*?)\).*?SERVICE_NAME=(.*?)\).*?/)) != 0)
{
    $rac_result = $host.":".$port.":".$service_name;
    $db_result = $host.":".$service_name;
}
else
{
    print "em_error=Error collecting the Database Information\n";
    exit 0;
}

#first we need to determine if it it a DB instance or RAC
#check if it is a DB instance
if (($db_index = index ($l_conn_desc, "LOAD_BALANCE=")) == -1)
{
    print "em_result=".$ecmAssoc::CONNECTS_TO."||".$ecmAssoc::ORACLE_DATABASE_TYPE."|".$db_result."\n";
}
#it is is RAC, 
else
{
    # we can return any DB instance for this RAC and LL can find out the actual host
    print "em_result=".$ecmAssoc::CONNECTS_TO."||".$ecmAssoc::RAC_DATABASE_TYPE."|".$rac_result."\n";    
}
exit 0;
