#!/usr/local/bin/perl
# 
# $Header: ldap_config.pl 15-feb-2006.10:08:42 rayleung Exp $
#
# ldap_config.pl
# 
# Copyright (c) 2006, Oracle. All rights reserved.  
#
#    NAME
#      ldap_config.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    rayleung    02/15/06 - collect LDAP config metrics 
#    rayleung    02/15/06 - Creation

my $OSNAME = $^O;
my $conn_descriptor = $ENV{CONN_DESC};
my $ldap_oh = $ENV{LDAP_OH};
my $ias_file = "/config/ias.properties";
my $full_path;
my $ldap_host;
my $ldap_port;
my $ldap_ssl_port;
my $ldap_ssl;

chomp $conn_descriptor;
chomp $ldap_oh;

# get the complete path for file "ias.properties" 
if(($OSNAME eq "MSWin32") or ($OSNAME eq "Windows_NT"))
{
    $ias_file =~ s/\//\\/g;
    $full_path = $ldap_oh . $ias_file;
}
else
{
    $full_path = $ldap_oh . $ias_file;
}

# check to see if ias.properties exists
if( ! -e $full_path )
{
    print "em_error=Cannot open file \"ias.properties\"\n";
}
# if ias.properties exists, opens it
else
{
    #get the OID host and port info
    open( CONFFILE, $full_path );
    while( <CONFFILE> )
    {
        my $current_property = $_;
  
         #trim the leading and trailing spaces
        chomp( $current_property );
        $current_property  =~ s#^\s+|\s+$##g;
  
        my $property_name;

        if( $current_property =~ /^OIDhost/ )
        {
            ( $property_name, $ldap_host ) = split /=/, $current_property, 2;
            chomp ( $ldap_host );
        }
        elsif( $current_property =~ /^OIDport/ )
        {
            ( $property_name, $ldap_port ) = split /=/, $current_property, 2;
            chomp ( $ldap_port );
        }
        elsif( $current_property =~ /^OIDsslport/ )
        {
            ( $property_name, $ldap_ssl_port ) = split /=/, $current_property, 2;
            chomp ( $ldap_ssl_port );
        }
        elsif ( $current_property =~ /^SSLOnly/ )
        {
            ( $property_name, $ldap_ssl ) = split /=/, $current_property, 2;
            chomp ( $ldap_ssl );
        }
    }
    close( CONFFILE );

    # return the OID connect descriptor, host, and both ports
    print "em_result=".$conn_descriptor."|".$ldap_host."|".$ldap_port."|".$ldap_ssl_port."\n";
}
exit 0;

