#!/usr/local/bin/perl
# 
# $Header: mailstore_stat.pl 16-aug-2005.03:06:57 sukhalsa Exp $
#
# mailstore_stat.pl
# 
# Copyright (c) 2005, Oracle. All rights reserved.  
#
#    NAME
#      mailstore_stat.pl - Response fetchlet for mailstore target type
#
#    DESCRIPTION
#      Try to login to mailstore and return 1 if successful. The returned
#      output on stdout is of the following format :
#      em_result=status|login_time|error_msg_if_any
#
#    NOTES
#      none
#
#    MODIFIED   (MM/DD/YY)
#    sukhalsa    08/16/05 - sukhalsa_bug-4540841
#    sukhalsa    08/15/05 - Creation (Bug fix 4540841)
# 

use strict;
use DBI;
use Time::HiRes;

require "emd_common.pl";

my $connectStr = $ENV{EM_TARGET_ADDRESS};
if (! $connectStr)
{
  ## This may be an upgraded target from 10.1.0.3, so, try using
  ## ENV{EM_SID_CONNECT}
  $connectStr = $ENV{EM_SID_CONNECT};
}
my $db_connect = $ENV{EM_TARGET_USERNAME} . "@" . $connectStr;

my $start_time = Time::HiRes::time;

my $db = DBI->connect('dbi:Oracle:',$db_connect ,$ENV{EM_TARGET_PASSWORD});
if (not defined $db)
{
  print "em_result=0|0|Could not connect $DBI::errstr\n";
  ## We still return with exit 0 instead of exit 1 because otherwise it would
  ## be considered as fetchlet failure.
  exit 0;
}

my $end_time = Time::HiRes::time;

$db->disconnect;

# the end_time and start_time returned are in terms of seconds, 
# the logon_time should be in miliseconds
my $logon_time = ($end_time - $start_time) * 1000;

print "em_result=1|$logon_time|No errors\n";

exit 0;

