# $Header: nntp_in_service_stat.pl 18-jun-2004.07:51:29 jkrishna Exp $
#
# nntp_in_service_stat.pl
# 
# Copyright (c) 2003, 2004, Oracle. All rights reserved.  
#
# NAME
# nntp_in_service_stat.pl - <one-line expansion of the name>
#
# DESCRIPTION
# This script posts and retrieves a message from a news server
# returns down status if the server could not be contacted.
#
# NOTES
# Uses Net::NNTP
#
# MODIFIED   (MM/DD/YY)
# jkrishna   06/18/04 - jkrishna_gridctrl_040609
# jkrishna   04/20/03 - Creation
# 

use Net::NNTP;
use Time::HiRes;

# Common params
$target_name=$ENV{EM_TARGET_NAME};
## FOR NT look for COMPUTERNAME
$agent_host=$ENV{HOST};

#nntp parameters
$nntp_host=$ENV{EM_NNTP_HOST};
$nntp_newsgroup=$ENV{EM_NNTP_NEWSGROUP};

$nntp_sender_id="EM\@$nntp_host";

print "Host: $nntp_host, Sender: $nntp_sender_id, Newsgroup: $nntp_newsgroup\n";

$start_time = Time::HiRes::time();

#default timeout is 120 sec
$nntp = new Net::NNTP($nntp_host);

if (defined $nntp)
{
    $connect_time = Time::HiRes::time() - $start_time;
    $status = 1;

    @header = ("Newsgroups: $nntp_newsgroup", "Subject: EMail NNTP Inbound Service Status check [$start_time]" ,"From: $smtp_sender_id");
    @body = ("This is an automated message posted by Oracle Enterprise Manager Grid Control");
    
    $start_time = Time::HiRes::time();

    $postrslt = $nntp->post(@header,"",@body);

    $post_time = Time::HiRes::time() - $start_time;

    if( not defined $postrslt ) {
      $post_time = 0;
    }

    $start_time = Time::HiRes::time();

    $nntp->group($nntp_newsgroup);

    @art = $nntp->article;

    $read_time = Time::HiRes::time() - $start_time;    

    if( not defined @art) {
      $read_time = 0;
    }

    $post_time = toMilliSec($post_time);  
    $connect_time = toMilliSec($connect_time);  
    $read_time = toMilliSec($read_time);
    $total_time = $connect_time + $post_time + $read_time;

    printf ("em_result=%d|%.2f|%.2f|%.2f|%.2f\n", $status, $total_time, $connect_time, $post_time, $read_time);

    $nntp->quit;  
}
else
{
    print "Connection failed\n";
    $status = 0;
    print "em_result=$status\n";
}

sub toMilliSec 
{
    my ( $time_in_sec) = @_;
    return $time_in_sec * 1000;
}

