#!/usr/local/bin/perl
# 
# $Header: ocal_assoc.pl 14-feb-2006.13:34:10 rayleung Exp $
#
# ocal_assoc.pl
# 
# Copyright (c) 2006, Oracle. All rights reserved.  
#
#    NAME
#      ocal_assoc.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    rayleung    02/14/06 - assoc in Livelink 
#    rayleung    02/14/06 - Creation
# 

# relationship types are defined in ecmassoc.pm
use ecmAssoc;

# collect the ldap target info
my $OSNAME = $^O;
my $ocal_oh = $ENV{OCAL_OH};
my $conf_file = "/ocal/misc/unison.ini";
my $full_path;
my $ldap_host = "";
my $ldap_port;
my $ldap_ssl_port;
my $ldap_ssl;

chomp $ocal_oh;

#get the complete path for file "unison.ini" 
if(($OSNAME eq "MSWin32") or ($OSNAME eq "Windows_NT"))
{
    $conf_file =~ s/\//\\/g;
}
$full_path = $ocal_oh . $conf_file;

# check to see if unison.ini exists
if ( -e $full_path )
{
    open( CONFFILE, $full_path );

    my $category = "";

    while( <CONFFILE> )
    {
        my( $current_line ) = $_;

        # chop the current line
        chomp( $current_line );

        # trim the leading and trailing spaces
        $current_line =~ s/^\s+|\s+$//g;

        # ignore comments - lines starting with "#" and empty line
        if( $current_line =~ /^#/ )
        {
            next;
        }

        # if the line begins with a "[" and ends with a "]", then this is a category
        if( $current_line =~ /^\[/ && $current_line =~ /\]$/ )
        {
            # remove leading "[" 
            $current_line =~ s/^\[//;

            # remove the trailing "]"
            $current_line =~ s/\]$//;

            # remove the leading the trailing spaces
            $current_line =~ s/^\s+|\s+$//g;

            $category_name = $current_line;
        }

        # check if the category name is "LDAP"
        if ($category_name eq "LDAP")
        {
            # search the OID host and port
            next unless $current_line =~ /^.+\s*=\s*.*/;

            # split the current line based on "="
            ( $pname, $pvalue ) = split( /=/, $current_line );

            # trim the leading and trailing spaces
            $pname =~ s/^\s+|\s+$//g;

            # trim the leading and trailing spaces
            $pvalue =~ s/^\s+|\s+$//g;

            if (!$ldap_ssl || !$ldap_host || !$ldap_ssl_port || !$ldap_port)
            {
                if ($pname eq "security")
                {
                    $ldap_ssl = $pvalue;
                }
                elsif ($pname eq "host")
                {
                    $ldap_host = $pvalue;
                }
                elsif ($pname eq "secure-port")
                {
                    $ldap_ssl_port = $pvalue;
                }
                elsif ($pname eq "port")
                {
                    $ldap_port = $pvalue;
                }
             }
            else
            {
                last;
            }
        }
    }
    print "em_result=".$ecmAssoc::CONNECTS_TO."||".$ecmAssoc::ORACLE_LDAP_TYPE."|".$ldap_host.":".$ldap_port.":".$ldap_ssl_port."\n";
}
else
{
    print "em_error=Cannot open file \"".$full_path."\"\n";
}

exit 0;
