#!/usr/local/bin/perl
# 
# $Header: ocal_status.pl 21-mar-2005.17:10:52 stakeda Exp $
#
# ocal_status.pl
# 
# Copyright (c) 2005, Oracle. All rights reserved.  
#
#    NAME
#      ocal_status.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    stakeda     03/21/05 - stakeda_bug-4233661
#    stakeda     03/21/05 - remove TEMP 
#    stakeda     03/21/05 - [4233661] status value change, merged for 10gR2
#    rayleung    03/16/05 - rayleung_bug-4233640
#    rayleung    03/14/05 - Creation
# 

#require "emd_common.pl";

$ocal_oh = $ENV{ORACLE_HOME};
$ocal_dir = "ocal";

my $status = 0;
my $status_string = "";
my $status_result = "";

# get the version number of Calendar Server
chomp($calversion = `$ocal_oh/$ocal_dir/bin/profilget -f $ocal_oh/$ocal_dir/misc/unison.ini -s PRODUCT -k version`);
if($calversion eq "")
{
   err_exit("Invalid operation for getting the version number\n");
}

# get the status value of Calendar Server
chomp($status_result = `$ocal_oh/$ocal_dir/bin/unistatus -oem`);
if($status_result eq "")
{
   err_exit("Invalid operation for getting the status string\n");
}

#EMD_PERL_DEBUG("The OCS Version for Calendar Server in ocal_status is $calversion\n");

# status value will only be remapped if the version number is 9.0.4
# the mapping will be:
#     2 -> 0 (down -> down)
#     1 -> 1 (partially up -> up)
#     0 -> 1 (up -> up)

if( $calversion =~ /^(9\.0\.4)/ )
{
    $status = substr($status_result, 10, 1);
    $status_string = substr($status_result, 12);
    if ( $status eq "2" )
    {
        $status = 0;
        $status_string = "Down";
    }
    else
    {
        $status = 1;
        $status_string = "Up";
    }
    print "em_result=$status"."|"."$status_string\n";
}
else
{
    print "$status_result\n";
}
exit 0;

sub err_exit
{
        my ($exit_error_msg) = @_;
        print "em_error=$exit_error_msg";
        exit 0;
}

