# $Header: ocas_apache_config.pl 03-aug-2005.20:39:25 rayleung Exp $
#
# ocas_apache_config.pl
# 
# Copyright (c) 2003, 2005, Oracle. All rights reserved.  
#
# NAME
# ocas_apache_config.pl - parse the ocas apache file ocal.conf
#
# DESCRIPTION
# This script invokes the java class that collects the ocs component config data
#
# NOTES
#
# MODIFIED   (MM/DD/YY)
#    rayleung    02/01/06 - Creation
# 

# set up to accept user input
use Getopt::Long;

# collect the ldap target info
my $OSNAME = $^O;

# get the $ORACLE_HOME from UI
my $l_oracle_home;
GetOptions(
            "OracleHome=s" => \$l_oracle_home);
chomp $l_oracle_home;

#get the complete path for file "ocal.conf" 
my $apache_file = "/ocas/conf/ocal.conf";
my $full_path = $l_oracle_home . $apache_file; 

#convert the forward slash to backward slash if the OS is NT
if(($OSNAME eq "MSWin32") or ($OSNAME eq "Windows_NT"))
{
    $full_path =~ s/\//\\/g;
}

my @ocas_apache_results;
my $global_var = "Global Variable";
my $em_result = "em_result=";
my $separator = "|";
my $seperator2 = ",";

# check to see if ias.properties exists
if ( -e $full_path )
{
    $directive = "";
    $argument = "";
    $tag_name = "";
    $tag_value = "";

    # get the OID host and port info
    open( CONFFILE, $full_path );
    while( <CONFFILE> )
    {
        my $current_line = $_;

        # trim the leading and trailing spaces
        chomp( $current_line );
        $current_line  =~ s#^\s+|\s+$##g;

        # trim comments
        if ($current_line =~ /^(.*?)\#.*$/)
        {
            $current_line = $1;
        }
        # trim whitespace
        if ($current_line =~ /^\s*(.*?)\s*$/)
        {
            $current_line = $1;
        }

        if (length($current_line) == 0 || $current_line =~ /^#\s*.*/)
        {
            # this is either a blank line or comment, so skip it
        }
        elsif ($current_line =~ /^<\/(.*)>$/)
        {
            # this is a directive with a closing tag
            my $tag = $1;
            chomp ($tag);
            if ($tag eq $tag_name)
            {
                $tag_name = "";
                $tag_value = "";
            }
            elsif ($tag_name =~ /(.*),$tag$/)
            {
                $tag_name = $1;
                if ($tag_value =~ /(.*)\,.*$/)
                {
                    $tag_value = $1;
                }
            }
        }
        elsif ($current_line =~ /^<(.*)>$/)
        {
            # this is a directive with a starting tag
            my $tag = $1;

            if ($tag =~ /^(\S*)\s+(.*)$/)
            { 
                my $arg1 = $1;
                my $arg2 = $2;
 
                # directive is a start tag with arguments
                if ($tag_name =~ /^IfModule/)
                {
                    $tag_name = $tag_name.$seperator2.$arg1;
                    $tag_value = $tag_value.$seperator2.$arg2;              
                }
                elsif (($arg1 eq "Location" || $arg1 eq "Directory") && $tag_name eq "")
                {
                    $tag_name = $arg1;
                    $tag_value = $arg2;
                }
                elsif ($arg1 eq "IfModule")
                {
                    $tag_name = $arg1;
                    $tag_value = $arg2;
                }
            }
        }
        elsif ($current_line =~ /^(\S+)\s+(.*)$/)
        {
            my $arg1 = $1;
            my $arg2 = $2;

            if ($arg1 eq "FastCgiExternalServer")
            {
                $directive = $arg1;
                $argument = $arg2;

                # strip leading and trailing spaces from directive and argument
                chomp ($directive);
                chomp ($argument);

                # for directive "FastCgiExternalServer"
                if ((($sub_arg1, $sub_arg2) = ($argument =~ /^(\S+)\s+(.*)$/)) != 0)
                {
                    push (@ocas_apache_results, $em_result.$global_var.$separator.$directive." ".$sub_arg1.$separator.$sub_arg2."\n");
                }
                else
                {
                    push(@ocas_apache_results, $em_result.$global_var.$separator.$directive.$separator.$argument."\n");
                }
            }
            elsif ($tag_name eq "")
            {
                # this is a simple directive with arguments and no tag 
                $directive = $arg1;
                $argument = $arg2;

                # strip leading and trailing spaces from directive and argument
                chomp ($directive);
                chomp ($argument);

                # with more than one argument
                if ($argument =~ /(\S+)\s+(\S+)/)
                {
                    push (@ocas_apache_results, $em_result.$directive.$separator.$1.$separator.$2."\n"); 
                }
                else
                {
                    push (@ocas_apache_results, $em_result.$global_var.$separator.$directive.$separator.$argument."\n");
                }
            }
            elsif ($tag_name =~ /^IfModule/)
            {
                my $sub_directive = $arg1;
                my $sub_argument =$arg2;

                chomp ($sub_directive);
                chomp ($sub_argument);
            
                push (@ocas_apache_results, $em_result.$tag_value.$separator.$sub_directive.$separator.$sub_argument."\n");     
                
            }
            else
            {
                # this is a directive with arguments within a tag
                push (@ocas_apache_results, $em_result.$tag_value.$separator.$arg1.$separator.$arg2."\n");
            }
        }
    }
    close( CONFFILE );
}
else
{
    print "em_error=Cannot open file \"".$full_path."\"\n";
    exit 0;
}

# print out all the association targets and its properties
foreach $result (@ocas_apache_results)
{
  print $result;
}

exit 0;
