#!/usr/local/bin/perl
# 
# $Header: ocas_assoc.pl 10-apr-2007.10:09:00 ndutko Exp $
#
# ocas_assoc.pl
# 
# Copyright (c) 2006, 2007, Oracle. All rights reserved.  
#
#    NAME
#      ocas_assoc.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    ndutko      04/10/07 - Movement of calconfig.jar from CCR_HOME/lib to
#                           sysman/admin/lib
#    rayleung    02/14/06 - associtaion for ocas in Livelink 
#    rayleung    02/14/06 - Creation
# 

#  association types are defined in ecmassoc.pm
use ecmAssoc;
# set up to accept user input
use Getopt::Long;

my $OSNAME = $^O;
my $cmd = "";
my $l_oracle_home;

# ocas targets associate parameters
GetOptions(
            "OracleHome=s" => \$l_oracle_home);

# assoc resutls
my @ocas_assoc_results;

# parameters for oracle_database association
$ocas_params = "aparam=labeleduri;appuri";

# construct the oracle_database/mailstore association command
if(($OSNAME eq "MSWin32") or ($OSNAME eq "Windows_NT"))
{
    # Need to verify to make sure it works in NT
    $cmd="$l_oracle_home\\jdk\\bin\\java -classpath $l_oracle_home\\jlib\\repository.jar::$l_oracle_home\\ccr\\sysman\\admin\\lib\\calconfig.jar:$l_oracle_home\\jlib\\calconfig.jar oracle.sysman.ocs.cfg.OcasAssocData $l_oracle_home \"$ocas_params\"";
}
else
{
    $cmd="$l_oracle_home/jdk/bin/java -classpath $l_oracle_home/jlib/repository.jar:$l_oracle_home/ccr/sysman/admin/lib/calconfig.jar:$l_oracle_home/jlib/calconfig.jar oracle.sysman.ocs.cfg.OcasAssocData $l_oracle_home \"$ocas_params\"";
}

# exec the command
my @results = `$cmd`;

# get the associate result
foreach $result (@results)
{
    chomp $result;
    if (index ($result, "assoc_result" ) != -1)
    {
        $result =~ s#assoc_result=x-oracle-calendar:\/\/##g;
        push(@ocas_assoc_results, "em_result=".$ecmAssoc::CONNECTS_TO."||oracle_calendar_ocal|".$result."\n");
    }
    elsif (index ($result, "em_error" ) != -1)
    {
        push(@ocas_assoc_results, $result);
    }
}

# print out all the association targets and its properties
foreach $result (@ocas_assoc_results)
{
  print $result;
}

exit 0;

