# $Header: ocas_dbsize.pl 30-jul-2003.18:33:55 gmulchan Exp $
#
# ocas_dbsize.pl
# 
# Copyright (c) 2001, 2003, Oracle Corporation.  All rights reserved.  
#
#    NAME
#      ocas_dbsize.pl <oracle home>
#
#    DESCRIPTION
#      This file generates output about the database size for ocas in
#      the followign format:
#      em_result=<file_sys_name>|<size of file system>| \
#                <space used>| \
#                <space available for file creation by nonpriv users>| \
#                <% available>
#   
#
#
#
#    NOTES
#     for each file system found by the df command (SunOS) or bdf (HP)  
#
#    IMPORTANT:
#     This script is not to be used alone.  It is intended for use by the Oracle
#     Enterprise Manager 4.0
#
# 

my $whichdir = $ARGV[0];
$whichdir =~ s/\/$//;
$whichdir .= "/ocas/";
@DBS = ("linkdb","sessiondb");

for( my $i=0; $i <= $#DBS; $i++ ) {
  
  $out = &run_df( "$whichdir$DBS[$i]" ) ;
  print "$out";
}

sub run_df() {
  my ($dir) = @_;
  my $ostype = `/bin/uname -s`;
  chomp($ostype);

   my $command_out;
   my $du_out;
   $du_out = `du -k -s $dir | sed -e "s/\\([0-9]\\{1,30\\}\\)\\(.*\\)/\\2 | \\1/"`; 
   chop($du_out);
   $du_out=~ s/^[\t\s\n]+//;

   ## print "$du_out\n";
   if ($ostype eq "Linux")
   {
       $command_out = `/bin/df -x nfs -x tmpfs -x shm  -Pk $dir | /usr/bin/tail +2 | /bin/sort | /usr/bin/uniq` || die "Could not execute df";
   }
   
   if ($ostype eq "SunOS") 
   {
       $command_out = `df -F ufs -k $dir | tail +2` or die "Could not execute df";
   }        
   
   if ($ostype eq "HP-UX")
   {
       $command_out = `bdf -l $dir | tail +2` || die "Could not execute bdf";
   }
   
   if ($ostype eq "OSF1")
   {
       $command_out = `df -Pk -t nonfs $dir | tail +2` or die "Could not run df -Pk";
   }
   
   ## print "$command_out"; 
   chop($command_out);
   $command_out =~ s/^[\t\s\n]+//;
   my @res = split(m/[\n\t\s]+/, $command_out);
   
   my $totalmb;
   my $usedmb;
   my $availmb;
   my $dev;
   my $availpct;
   
   for ( my $i = 0; i < scalar(@res)/6; $i++)
   {
       $fs=shift(@res);
       $totalmb = shift(@res)/1024;
       $usedmb = shift(@res)/1024;
       $availmb = shift(@res)/1024;
       shift(@res);
       $dev = shift(@res);
       
       if(!($totalmb eq "" || $totalmb == 0))
       {        
          $availpct = 100*$availmb/$totalmb;
       }
       
       if($availpct eq "" || $availpct == 0)
       {
          $outstr = sprintf "em_result=$du_out| $dev | $fs | %.2f | %.2f |%.2f  \n", ($totalmb, $usedmb, $availmb);
          return $outstr;
       }         
       else
       {
          $outstr = sprintf  "em_result=$du_out| $dev|$fs|%.2f|%.2f|%.2f|%.2f\n", ($totalmb, $usedmb, $availmb, $availpct);
          return $outstr;
       }
   }

   return "em_error=No data returned from df or du commands";
}
