# $Header: ocas_ping.pl 29-aug-2005.11:05:39 stakeda Exp $
#
# ocas_ping.pl
# 
# Copyright (c) 2001, 2005, Oracle. All rights reserved.  
#
#    NAME
#      ocas_ping.pl - pings the calendar app's system page
#
#    DESCRIPTION
#      urlStats.pl <machine_name> <port> <status_url> 
#
#      where:
#         <machine_name> is the name of the machine that we want to get stats
#                        from.
#         <port> the port on <machine_name> on which the web server is 
#                listening
#         <status_url> the url of the status page for this web server.
#         example:  if the url is http://foo:9090/fighter
#                   then <status_url> = "/fighter"
#
#    returns: The response return time
#
#    NOTES
#       Remember that we use the middletier perl libraries.
#
#    IMPORTANT: 
#     This script is not to be used alone.  It is intended for use by the Oracle
#     Enterprise Manager 4.0
#
#    MODIFIED   (MM/DD/YY)
#       stakeda  08/29/05 - [4572896] flip status value 
#       rgorle   07/29/05 - fix bug#4260311 
#       gmulchan 07/30/03 - gmulchan_ocsv1_main_merge


require "emd_common.pl";
require HTTP::Request;
require LWP::UserAgent;
use LWP::Debug qw(-);
use Time::HiRes qw( gettimeofday tv_interval );

# Set an alarm so that we do timeout a connection that is not 
# coming back (15 second wait sounds enough)
my $timeout = 15;

my $machine;
my $port;
my $status;
my $ua;
my $url;
my $request; 
my $response;
my @lines;
my $value;
my $result;
my $to_result;
my $attr;

if( $#ARGV!=2 ) 
{
  die("Usage:  urlStats.pl <host> <port> <urlpath>");
}
($machine, $port, $status) = @ARGV;

$to_result = "em_error=Error occured getting urlstats. Request timed out\n";
$ua = LWP::UserAgent->new;

# I abandoned the agent's timeout mechanism for the native alarm()
# $ua->timeout(5);
# $SIG{'ALRM'} = sub { print "$to_result\n"; exit 0;};
# $ua->use_eval(1);


eval {
  # set time 0
  ($times_0, $timems_0) = gettimeofday;

  local $SIG{ALRM} = sub { 
    my $resp_time = tv_interval ([$times_0, $timems_0]) * 1000;
    print "em_result=1|$resp_time\n";
    print "em_message=Error occured getting urlstats. Request timed out\n";
    exit(0);
  };

  # form request
  $url = "http://".$machine.":".$port.$status;
  $request = HTTP::Request->new(GET => "$url");

  # Re-applying timeout for Win32 arch (03/29/2005 -Bibi)
  $ua->timeout( $timeout );

  # get response
  $response = $ua->request($request);

  $ua->use_eval(1);

};


# calculate elapsed time

if($response->is_error) 
{
    # some error occured..let's inform the EDM about it
    print "em_result=0|-10\n";
    print "em_message=Error occured getting $url \n";
    exit;
} 
else 
{
    my $resp_time = tv_interval ([$times_0, $timems_0]) * 1000;
    print "em_result=1|$resp_time\n";
}

exit(0);
