#  $Header: ocas_ps.pl 16-aug-2003.14:13:44 skumar Exp $
# 
# Copyright (c) 2001, 2003, Oracle Corporation.  All rights reserved.  
#
#    NAME
#      ocas_ps.pl  
#
#    DESCRIPTION
#      This script computes for Oracle Calendar 
#      the process size in VM, % physical memory and %CPU consumption
#
#    NOTES
#
#    IMPORTANT: 
#     This script is not to be used alone.  It is intended for use by the Oracle
#     Enterprise Manager 4.0
#

$ENV{PATH} = "/bin:/usr/bin:/usr/local/bin:/usr/sbin";

$process_nm = "ocas";
$process_type = ".fcgi";

$os = `uname -s`;
chomp ($os);
if ($os eq "SunOS" || $os eq "Linux") 
{
   @PSINFO = `ps -e -o comm,ppid,pid,vsz,pmem,pcpu,etime |grep $process_nm| grep $process_type | sort `;
}
elsif ($os eq "OSF1" || $os eq "AIX")
{
   @PSINFO = `ps -e -o comm,ppid,pid,vsz,pmem,pcpu,etime|grep $process_nm| grep $process_type | sort `;
}
elsif ($os eq "HP-UX")
{
   $ENV{UNIX95} = "XPG4";
   @PSINFO = `ps -e -o comm,ppid,pid,vsz,sz,pcpu,etime|grep $process_nm| grep $process_type | sort`;
}
elsif ($os eq "Darwin")
{
   @PSINFO = `ps awxxo command,ppid,pid,vsz,pmem,pcpu,start|grep $process_nm| grep $process_type | sort`;
}
else 
{
   print "em_error=Platform - $os not supported\n";
}

$procID = 0;
$sz     = 0;
$CPU    = 0;
my $pid_index = 1;
foreach $oidProcessInfo (@PSINFO)
{
  @data = split(/\s+/, $oidProcessInfo);
  {
    @procNmLong = split( /\//, $data[0] );
    $procNM = $procNmLong[ $#procNmLong ];
    $procID = $data[2];
    $sz     = $data[3];
    if ($os eq "OSF1") {
      $sz=convertSizeToKB($sz);
    }
    $CPU    = $data[5];
    $etime  = $data[6];
    print "em_result=$procNM ($pid_index)|$procID|$etime|$sz|$CPU\n";
    $pid_index++;
  }
}

sub convertSizeToKB
{
  my $size = shift(@_);
  my $ignore = '';

  if ($size =~ /K/) # KB
  {
    ($size, $ignore) = split('K', $size);
  }
  elsif ($size =~ /M/) # MB
  {
    ($size, $ignore) = split('M', $size);
    $size *= 1024;
  }
  elsif ($size =~ /G/) # GB
  {
    ($size, $ignore) = split('G', $size);
    $size *= 1024 * 1024;
  }

  return $size;
} 
