#!/usr/local/bin/perl
# 
# $Header: ocas_version.pl 01-dec-2005.15:10:58 rayleung Exp $
#
# ocas_version.pl
# 
# Copyright (c) 2005, Oracle. All rights reserved.  
#
#    NAME
#      ocas_version.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    rayleung    12/01/05 - code cleanup 
#    rayleung    11/30/05 - get the Version value using OPatch command 
#    rayleung    11/22/05 - bug 4726562 - add instance property 'Version' 
#    rayleung    11/22/05 - Creation
#
require "emd_common.pl";

$ENV{ORACLE_HOME} = $ENV{EM_CLIENTOH};
$na = "Not Available";

if (! -x "$ENV{EM_CLIENTOH}/OPatch/opatch") 
{
   print "em_result=$na";
   exit 0;
}

$ocasVer = "0";
$maxOcasVer = 0;
if (-e "$ENV{EM_CLIENTOH}/oraInst.loc") 
{
   $command = "$ENV{EM_CLIENTOH}/OPatch/opatch lsinventory -detail -invPtrLoc $ENV{EM_CLIENTOH}/oraInst.loc";
} 
else 
{
   $command = "$ENV{EM_CLIENTOH}/OPatch/opatch lsinventory -detail";
}

if (! open(OPATCH, "$command|"))
{
   err_exit("Invalid operation: $command");
}

while (<OPATCH>)
{
  next unless /^Oracle Calendar Application System/;
  if (/(\d+(\.\d+)*)/)
  {
    $ver = join("",split(/\./,$1));
    if ( $ver > $maxOcasVer )
    {
        $maxOcasVer = $ver;
        $ocasVer = $1;
    }
  }
}
close OPATCH;

if ($ocasVer eq "" or $ocasVer eq "0")
{
  print "em_result=$na";
}
else
{
  print "em_result=$ocasVer";
}
exit 0;

sub err_exit
{
   my ($exit_error_msg) = @_;
   print "em_error=$exit_error_msg\n";
   exit 0;
}
