#!/usr/local/bin/perl
# 
# $Header: oidclient.pl 24-nov-2004.01:31:24 tjaiswal Exp $
#
# oidclient.pl
# 
# Copyright (c) 2003, 2004, Oracle. All rights reserved.  
#
#    NAME
#      oidclient.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    cbagade     11/22/04 - Bug 3656449 
#    tjaiswal    11/24/04 - Bug 3985127 
#    tjaiswal    02/12/04 - Bug 3432641 
#    abhavnan    11/13/03 - fix env var requirements for ldap utils:bug 3251925
#    gmulchan    07/30/03 - gmulchan_ocsv1_main_merge
#    tjaiswal    04/20/03 - Creation
# 
#use strict;
use Time::HiRes;

#ldap parameters
$ldap_oh=$ENV{EM_CLIENTOH};
$ldap_host=$ENV{EM_LDAP_HOST};
$ldap_port=$ENV{EM_LDAP_PORT};
$ldap_username=$ENV{EM_LDAP_USER};
$ldap_password=$ENV{EM_LDAP_PASSWORD};
$dc=$ENV{EM_DC};

#
# LDAP utilities seem to need these env vars setup before they can function
# properly
#
$ENV{ORACLE_HOME}="$ldap_oh";
$ENV{PATH}="$ldap_oh/bin".":".$ENV{PATH};
$ENV{LD_LIBRARY_PATH}="$ldap_oh/lib".":".$ENV{LD_LIBRARY_PATH};

# metrics
######
$status = 1;			# be optimistic
$msgsrch_time = 0;
$addrsrch_time = 0;
$basesrch_time = 0;
$compare_time = 0;
####

print "Environment variables:\n";
print "ORACLE_HOME=".$ENV{ORACLE_HOME}."\n";
print "PATH=".$ENV{PATH}."\n";
print "LD_LIBRARY_PATH=".$ENV{LD_LIBRARY_PATH}."\n";
print "Connecting.. $ldap_host:$ldap_port :: $ldap_username\n";

print "\nMessaging Search:\n";
$command = $ldap_oh."/bin/ldapsearch -h ".$ldap_host." -p ".$ldap_port." -D ";
$command = $command.'"'.$ldap_username.'"'." -w ".$ldap_password." -b ";
$command = $command.'"'."dc=".$dc.'"'." -s sub cn=oraclecontext dn";

$msgsrch_time = doLdapOperation ($command);

print "\nAddressing Search:\n";
$command = $ldap_oh."/bin/ldapsearch -h ".$ldap_host." -p ".$ldap_port." -D ";
$command = $command.'"'.$ldap_username.'"'." -w ".$ldap_password." -b ";
$command = $command.'"'."dc=".$dc.'"'." -s sub cn=oraclecontext* dn";

$addrsrch_time = doLdapOperation ($command);

print "\nBase Search:\n";
$command = $ldap_oh."/bin/ldapsearch -h ".$ldap_host." -p ".$ldap_port." -D ";
$command = $command.'"'.$ldap_username.'"'." -w ".$ldap_password." -b ";
$command = $command.'"'."dc=".$dc.'"'." -s base objectclass=*";

$basesrch_time = doLdapOperation ($command);

print "\nCompare:\n";
$command = $ldap_oh."/bin/ldapcompare -h ".$ldap_host." -p ".$ldap_port." -D ";
$command = $command.'"'.$ldap_username.'"'." -w ".$ldap_password." -b ";
$command = $command.'"'.$ldap_username.'"'." -a userpassword -v ".$ldap_password;

#
# no need to special case for ldapcompare. if it fails, should return non-zero code
#
$compare_time = doLdapOperation ($command);

# Important : Convert to milliseconds.
$msgsrch_time = toMilliSec($msgsrch_time) ;
$addrsrch_time = toMilliSec($addrsrch_time) ;
$basesrch_time = toMilliSec($basesrch_time) ;
$compare_time = toMilliSec($compare_time) ;

print "Messaging Search Time = $msgsrch_time\n";
print "Addressing Search Time = $addrsrch_time\n";
print "Base Search Time = $basesrch_time\n";
print "Compare Search Time = $compare_time\n";
printf ("em_result=%d|%.2f|%.2f|%.2f|%.2f\n", $status, $msgsrch_time,
    $addrsrch_time, $basesrch_time, $compare_time);

sub doLdapOperation
{

    my ($ldapcmd)  = @_;

    $start_time = Time::HiRes::time();
    print $ldapcmd;
    print "\n\n";

    print "ldapcmd: $ldapcmd \n";
    $rc = 0xffff & system($ldapcmd);
    $rc >>= 8;

    if ($rc != 0)
    {
        #exit 1;

        # regard this as status down
        print "em_error=Invalid ldap operation: $ldapcmd";
        print "\n";
        $status = 0;
        print "em_result=$status";        
        exit 0;
    }
    return (Time::HiRes::time() - $start_time);
}

sub toMilliSec 
{
    my ( $time_in_sec) = @_;
    return $time_in_sec * 1000;
}

