# $Header: pop_service_stat.pl 18-jun-2004.07:51:29 jkrishna Exp $
#
# pop_service_stat.pl
# 
# Copyright (c) 2003, 2004, Oracle. All rights reserved.  
#
#    NAME
#      pop_service_stat.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    jkrishna    06/18/04 - jkrishna_gridctrl_040609
#    jkrishna    05/28/04 - jkrishna_oes_grid_control
#    jkrishna    05/26/04 - v2.1 integration 
#    gmulchan    07/30/03 - gmulchan_ocsv1_main_merge
#    tjaiswal    04/25/03 - 
#    tjaiswal    04/22/03 - 
#    tjaiswal    04/20/03 - Creation
# 
#use strict;
use Net::POP3;
use Time::HiRes;

#pop parameters
$pop_host=$ENV{EM_POP_HOST};
$pop_username=$ENV{EM_POP_ID};
$pop_password=$ENV{EM_POP_PASSWORD};

# metrics

######
# $connect_time
# $login_time
# $open_email_time
####

print "Connecting.. $pop_host :: $pop_username\n";

# open a connection to the POP server

$start_time = Time::HiRes::time();
$server = Net::POP3->new( $pop_host );
if ($server) 
{
    $status = 1;
    $connect_time = Time::HiRes::time() - $start_time;

    # login, by default selects INBOX
    $start_time = Time::HiRes::time();
    $server->login( $pop_username, $pop_password );
    print "login done\n";
    $login_time = Time::HiRes::time() - $start_time;
    
    ($num_messages, $size) = $server->popstat();
    print "Number of messages in the inbox = $num_messages\n";
    print "Size of the mailbox = $size\n";

    # decide if this is a metric error or just status = down ?
    if (! defined  ($num_messages))
    {
        #print "em_error=Invalid Login\n";
        #$server->quit();
        #exit 1;

        # regard this as status down
        print "Login failed\n";
        $status = 0;
        print "em_result=$status";        
        exit 0;
    }

    # Read the first message
    $start_time = Time::HiRes::time();
    $lines = $server->get( 1 );
    $open_email_time = Time::HiRes::time() - $start_time;

    # close the connection
    $server->quit();

    $total_time = $connect_time + $login_time + $open_email_time;

    # Important : Convert to milliseconds.
    $connect_time = toMilliSec($connect_time) ;
    $login_time = toMilliSec($login_time);
    $open_email_time = toMilliSec($open_email_time) ;   
    $total_time = toMilliSec($total_time); 

    print "Connect Time = $connect_time\n";
    print "Login Time = $login_time\n";
    print "Open Email Time = $open_email_time\n";
    print "Total Time = $total_time\n";

    #printf ("em_result=%d\n", $status);
    printf ("em_result=%d|%.2f|%.2f|%.2f|%.2f\n", $status, $total_time,
    $connect_time, $login_time, $open_email_time);
}
else
{
    print "Connection failed\n";
    $status = 0;
    print "em_result=$status";
}

sub toMilliSec 
{
    my ( $time_in_sec) = @_;
    return $time_in_sec * 1000;
}
