#!/usr/local/bin/perl
# 
# $Header: rtc_assoc.pl 14-feb-2006.12:54:56 rayleung Exp $
#
# rtc_assoc.pl
# 
# Copyright (c) 2006, Oracle. All rights reserved.  
#
#    NAME
#      rtc_assoc.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    rayleung    02/14/06 - perl script for rtc association in Linvelink 
#    rayleung    02/14/06 - Creation
#

# association types are defined in ecmassoc.pm
use ecmAssoc;

# get the Oracle Home and RTC directory
my $OSNAME = $^O;
$rtc_oh = $ENV{RTC_OH};
$rtc_dir= $ENV{RTC_DIR};
my $rtc_conf = "/conf/imtinit.conf";
my $full_path;

# make sure the RTC directory name is available
if ($rtc_dir eq "")
{
    $rtc_dir = "imeeting";
}

# get the complete path for file "imtinit.conf"
my $conf_file = "/".$rtc_dir.$rtc_conf;
if(($OSNAME eq "MSWin32") or ($OSNAME eq "Windows_NT"))
{
    $conf_file =~ s/\//\\/g;
}
$full_path = $rtc_oh . $conf_file;

# check to see if the file exists
if ( -e $full_path )
{
    my $current_line;
    my $db_result;
    my $rac_result;

    open( CONFFILE, $full_path );

    while( <CONFFILE> )
    {
        $current_line = $_;

        # chop the current line
        chomp( $current_line );

        # trim the leading and trailing spaces
        $current_line =~ s/^\s+|\s+$//g;

        # ignore comments - lines starting with "#" and empty line
        if( $current_line =~ /^#/ )
        {
            next;
        }
        elsif( $current_line =~ /^oracle.imt.database.jdbc.connect/ )
        {
            my $host;
            my $port;
            my $service_name;

            # parse the connector descriptor
            if ((($host, $port, $service_name) = ($current_line =~ /\s*.*?HOST.*?=(.*?)\)\(PORT.*?=(.*?)\).*?SERVICE_NAME.*?=(.*?)\).*?/)) != 0)
            {
                $rac_result = $host.":".$port.":".$service_name;
                $db_result = $host.":".$service_name;
            }
            else
            {
                print "em_error=Error collecting the Database Information\n";
                exit 0;
            }

            # Since we have find the DB information, we can stop reading imtinit.conf
            last;
        }
    }

    # determine if it it a DB instance or RAC
    if (($db_index = index ($current_line, "LOAD_BALANCE")) == -1)
    {
        # it is a DB instance
        print "em_result=".$ecmAssoc::CONNECTS_TO."||".$ecmAssoc::ORACLE_DATABASE_TYPE."|".$db_result."\n";
    }
    else
    {
        # it is a RAC 
        # we can return any DB instance for this RAC and LL can find out the actual host
        print "em_result=".$ecmAssoc::CONNECTS_TO."||".$ecmAssoc::RAC_DATABASE_TYPE."|".$rac_result."\n";
    }
}
else
{
    print "em_error=Cannot open file \"".$full_path."\"\n";
}

exit 0; 
