#!/usr/local/bin/perl
# 
# $Header: rtc_config.pl 24-feb-2006.11:30:25 rayleung Exp $
#
# rtc_config.pl
# 
# Copyright (c) 2006, Oracle. All rights reserved.  
#
#    NAME
#      rtc_config.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    rayleung    02/24/06 - fix issue on collecting component level config 
#                           data 
#    rayleung    02/14/06 - perl scripts for collecting rtc config metrics in 
#                           Livelink 
#    rayleung    02/14/06 - Creation
#
 
# set up to accept user input
use Getopt::Long;

# get the OracleHome and RTC directory from instance property
$rtc_oh=$ENV{EM_CLIENTOH};
$rtc_dir=$ENV{EM_DIR};
$rtc_scope;

# scope parameter
GetOptions(
            "Scope=s" => \$rtc_scope );

# confirm the RTC directory
if ($rtc_dir eq "")
{
    $rtc_dir = "imeeting";
}

# collect the config data for system and instance level
if ($rtc_scope eq "system" || $rtc_scope eq "instance")
{
    my $property_name;
    my $property_value;

    $cmd = $rtc_oh."/".$rtc_dir."/bin/rtcctl getProperties -".$rtc_scope." true -maxlevel all";
    @command = `$cmd`;

    # throw an em_error message if rtcctl command returns exception
    if ($command[0] =~ /.*Exception.*/)
    {
        print "em_error=Error collecting configruation data - ".$command[0];
        exit 0;
    }
    else
    {
        foreach $line (0 .. $#command)
        {
            chomp($command[$line]);
            ($property_name, $property_value) = split /=/, $command[$line], 2;
            $property_value =~ s#\"##g;
            $property_value =~ s#\[#\[\"#g;
            $property_value =~ s#\]#\"\]#g;
            print "em_result=".$property_name."|".$property_value."\n";
        }
    }
}
# collect the config data for component 
else
{
    $comp_cmd =  $rtc_oh."/".$rtc_dir."/bin/rtcctl getProperties -cname ".$rtc_scope." -maxlevel advanced";
    @comp_command = `$comp_cmd`;

    my $property_name;
    my $property_value;
 
    # thrown an em_error message if rtcctl command returns exception
    if ($comp_command[0] =~ /.*Exception.*/)
    {
        print "em_error=Error collecting configruation data - ".$comp_command[0];
        exit 0;
    }
    else
    {
        foreach $result (0 .. $#comp_command)
        {
            chomp($comp_command[$result]);
            ($property_name, $property_value) = split /=/, $comp_command[$result], 2;
            $property_value =~ s#\"##g;
            $property_value =~ s#\]#\"\]#g;
            print "em_result=".$property_name."|".$property_value."\n";
        }
    }
}

exit 0;
