#!/usr/local/bin/perl
# 
# $Header: rtcmeeting.pl 07-sep-2005.11:13:23 rayleung Exp $
#
# rtcmeeting.pl
# 
# Copyright (c) 2005, Oracle. All rights reserved.  
#
#    NAME
#      rtcmeeting.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    rayleung    09/07/05 - bug 4595418 
#    rayleung    05/09/05 - rayleung_rtc_orahome
#    rayleung    05/06/05 - Creation
#

#
# [4053752] conference usage for the past calendar week
#
require "emd_common.pl";

$webconf_oh=$ENV{EM_CLIENTOH};
$webconf_dir=$ENV{EM_DIR};
$rtcVer=$ENV{RTC_VER};

if ($webconf_dir eq "")
{
    $webconf_dir = "imeeting";
}

@command = `$webconf_oh/$webconf_dir/bin/imtctl getusagestats -publish true`;

# err_exit if the command fails
unless (@command)
{
    err_exit("Invalid operation\n");
}

$webconf_output = "";

foreach $line (0 .. $#command)
{
    chomp($command[$line]);               # Clean up the line (remove \n)
    $command[$line] .= " ";
    if ( length($command[$line]) > 1 )    # check only if something left over
    {
        $webconf_output = $webconf_output.$command[$line];
    }
}

# err_exit if the command's output is blank
if ($webconf_output =~ /^\s*$/)
{
    err_exit("Invalid operations\n");
}

if ( index($webconf_output, "<usagestat") <= 0 )
{
    err_exit("Tag for usage stat not found\n");
}

my $usage_value = 0;
# get the meeting minutes value
($usage_value) = ($webconf_output =~ /usagestat[ ]+name=\"meeting_minutes\">([0-9]+)</);
print "em_result=$usage_value\n";

exit 0;

sub err_exit
{   
    my ($exit_error_msg) = @_;
        print "em_error=$exit_error_msg\n";
        exit 0;
}
 
