#!/usr/local/bin/perl
# 
# $Header: rtcver.pl 05-dec-2005.11:41:36 rayleung Exp $
#
# rtcver.pl
# 
# Copyright (c) 2004, 2005, Oracle. All rights reserved.  
#
#    NAME
#      rtcver.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    rayleung    12/05/05 - Backport rayleung_bug-4693122 from main 
#    rayleung    12/01/05 - code cleanup 
#    rayleung    11/30/05 - retrun Not Available if we cannot find RTC version 
#    rayleung    10/25/05 - bug 4693122 
#    rayleung    04/13/05 - bug 4256123 - remove TMPFILE 
#    rayleung    01/25/05 - changing the testing condition of $rc 
#    prbhoj      12/19/04 - Add Instance property for RTC Directory Name 
#    prbhoj      12/01/04 - prbhoj_rtc-3879870
#    prbhoj      12/01/04 - Creation
#
 
require "emd_common.pl";

$ENV{ORACLE_HOME} = $ENV{EM_CLIENTOH};
$na = "Not Available";

if (! -x "$ENV{EM_CLIENTOH}/OPatch/opatch") 
{
   print "em_result=$na";
   exit 0;
}

$rtcVer = "0";
$maxrtcVer = 0;

if (-e "$ENV{EM_CLIENTOH}/oraInst.loc") 
{
   $command = "$ENV{EM_CLIENTOH}/OPatch/opatch lsinventory -detail -invPtrLoc $ENV{EM_CLIENTOH}/oraInst.loc";
} 
else 
{
   $command = "$ENV{EM_CLIENTOH}/OPatch/opatch lsinventory -detail";
}

if (! open(OPATCH, "$command|"))
{
   err_exit("Invalid operation: $command");
}

while (<OPATCH>)
{
  next unless /^Oracle Real-Time Collaboration Core Components/;
  if (/(\d+(\.\d+)*)/)
  {
    $ver = join("",split(/\./,$1));
    if ( $ver > $maxrtcVer )
    {
        $maxrtcVer = $ver;
        $rtcVer = $1;
    }
  }
}
close OPATCH;

if ($rtcVer eq "" or $rtcVer eq "0")
{
    print "em_result=$na";
}
else
{
   print "em_result=$rtcVer";
}
exit 0;

sub err_exit
{
   my ($exit_error_msg) = @_;
   print "em_error=$exit_error_msg\n";
   exit 0;
}
