#!/usr/local/bin/perl
# 
# $Header: rtcver_category.pl 30-nov-2005.16:22:19 rayleung Exp $
#
# rtcver_category.pl
# 
# Copyright (c) 2005, Oracle. All rights reserved.  
#
#    NAME
#      rtcver_category.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    rayleung    11/30/05 - get the RTC version for category prop 
#    rayleung    11/30/05 - Creation
#
$oraHome=$ENV{ORACLE_HOME};
$webconf_oh=$ENV{EM_CLIENTOH};
$webconf_dir=$ENV{EM_DIR};

if ($webconf_dir eq "")
{
    $webconf_dir = "imeeting";
}

@command =`$webconf_oh/$webconf_dir/bin/imtctl getMonitorStats -publish true`;

# err_exit if the command fails
unless (@command)
{
    err_exit("Invalid operation\n");
}

$webconf_output = "";

foreach $line (0 .. $#command)
{
    chomp($command[$line]);               # Clean up the line (remove \n)
    $command[$line] .= " ";
    if ( length($command[$line]) > 1 )    # check only if something left over
    {
        $webconf_output = $webconf_output.$command[$line];
    }
}

# err_exit if the command's output is blank
if ($webconf_output =~ /^\s*$/)
{
    err_exit("Invalid output\n");
}

if ( index($webconf_output, "VERSION=") < 0 )
{
    $version = "9.0.4";
}
else
{
    $version = "9.0.5";
}

print "em_result=$version\n";
exit 0;


sub err_exit
{
    my ($exit_error_msg) = @_;
    print "em_error=$exit_error_msg\n";
    exit 0;
}
 
