# $Header: smtp_in_service_stat.pl 18-jun-2004.07:51:30 jkrishna Exp $
#
# smtp_in_service_stat.pl
# 
# Copyright (c) 2003, 2004, Oracle. All rights reserved.  
#
#    NAME
#      smtp_in_service_stat.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    jkrishna    06/18/04 - jkrishna_gridctrl_040609
#    jkrishna    05/28/04 - jkrishna_oes_grid_control
#    jkrishna    05/26/04 - v2.1 integration 
#    gmulchan    07/30/03 - gmulchan_ocsv1_main_merge
#    tjaiswal    04/25/03 - 
#    tjaiswal    04/22/03 - 
#    tjaiswal    04/20/03 - Creation
# 
use Net::SMTP;
use Time::HiRes;

####
# This script sends a test email to the mail server specified.
# returns down status if the server could not be contacted.
#
    
# Common params
$target_name=$ENV{EM_TARGET_NAME};
## FOR NT look for COMPUTERNAME
$agent_host=$ENV{HOST};

#smtp parameters
$smtp_host=$ENV{EM_SMTP_HOST};
$smtp_timeout=$ENV{EM_SMTP_TIMEOUT};
$smtp_sender_id=$ENV{EM_SMTP_SENDER_ID};
$smtp_sender_password=$ENV{EM_SMTP_SENDER_PASSWORD};
$smtp_recipient_id=$ENV{EM_SMTP_RECIPIENT_ID};

print "Host $smtp_host, $smtp_timeout : Sender $smtp_sender_id : Recipient $smtp_recipient_id\n";

$start_time = Time::HiRes::time();

if (defined $smtp_timeout)
{
    $smtp = Net::SMTP->new($smtp_host, Timeout=>$smtp_timeout);
}
else
{
    $smtp = Net::SMTP->new($smtp_host, Timeout=>60);
}

### TODO : The content of the email can be made rich
### with time when the email was sent, from where it was sent, for which 
### target it was sent etc.

if (defined $smtp)
{
    $connect_time = Time::HiRes::time() - $start_time;
    $status = 1;
    
    $start_time = Time::HiRes::time();
    $smtp->mail($smtp_sender_id);
    $smtp->to($smtp_recipient_id);
   
    # send a large message, maybe an attachement too
    $smtp->data();
    $smtp->datasend("To: $smtp_recipient_id\n");
    $smtp->datasend("Subject: Test message\n");
    $smtp->datasend("\n");
    $smtp->datasend("Test message from smtp_stat script\n");
    $smtp->datasend("Target Name = $target_name\n");
    $smtp->datasend("Target Name = $agent_host\n");

    $smtp->dataend();

    $time_to_send = Time::HiRes::time() - $start_time;    

    $total_time = toMilliSec($connect_time + $time_to_send);
    $connect_time = toMilliSec($connect_time);  
    $time_to_send = toMilliSec($time_to_send);

    #print "em_result=$status|$total_time|$connect_time|$time_to_send\n";
    printf ("em_result=%d|%.2f|%.2f|%.2f\n", $status, $total_time, $connect_time, $time_to_send);

    $smtp->quit;  
}
else
{
    print "Connection failed\n";
    $status = 0;
    print "em_result=$status";
}

sub toMilliSec 
{
    my ( $time_in_sec) = @_;
    return $time_in_sec * 1000;
}

