# $Header: vscrub_stat.pl 29-jul-2005.02:19:30 pallumpa Exp $
#
# vscrub_stat.pl
#
# Copyright (c) 2001, 2005, Oracle. All rights reserved.  
#
#    NAME
#      vscrub_stat.pl
#
#    DESCRIPTION
#       The Virus Scrubber server should be marked as down if there is no $proc_name process
#       talking to this Virus Scrubber server as obtained from a "ps" command.
#       The OS command to use for this is:
#       for solaris: ps -ef | grep $proc_name | grep -v 'grep $proc_name'
#       for linux: /usr/ucb/ps -auxww | grep $proc_name | grep -v 'grep $proc_name'
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    pallumpa   07/29/05 - Fix 4519421 - Fix porting issues 
#    jkrishna   06/18/04 - jkrishna_gridctrl_040609
#    jkrishna   05/28/04 - jkrishna_oes_grid_control
#    tjaiswal   02/12/04 - Bug 3432641 
#    tjaiswal   11/11/03 - tjaiswal_bug-3206136 
#    hwjung     10/25/03 - Creation - Bug3206136
#

my $OSNAME = $^O;

# the process name is the same irrespective of the platform
$proc_name = "esvs";

print "OS: $OSNAME \n";
print "Process name: $proc_name \n";

if( ($OSNAME eq "solaris") || ($OSNAME eq "sunos") )
{
    chomp ($vscrub_proc_num = `ps -ef | grep $proc_name | grep -v 'grep $proc_name'|wc -l`);
}
elsif( $OSNAME eq "hpux" )
{
    chomp ($vscrub_proc_num = `ps -ef | grep $proc_name | grep -v 'grep $proc_name'|wc -l`);
}
elsif( $OSNAME eq "aix" )
{
    chomp ($vscrub_proc_num = `ps -ef | grep $proc_name | grep -v 'grep $proc_name'|wc -l`);
}
elsif( $OSNAME eq "dec_osf" )
{
    chomp ($vscrub_proc_num = `ps -ef | grep $proc_name | grep -v 'grep $proc_name'|wc -l`);
}
elsif( $OSNAME eq "linux" or $OSNAME eq "darwin" )
{
    chomp ($vscrub_proc_num = `/bin/ps -auxww | grep $proc_name | grep -v 'grep $proc_name'|wc -l`);
}
elsif( ($OSNAME eq "MSWin32") or ($OSNAME eq "Windows_NT") )
{
    # for windows, nmupm TopProcs is used to get the process info
    my @e_processes = `$ENV{EMDROOT}/bin/nmupm TopProcs`;

    foreach $e_process ( @e_processes ) 
    {
        # chomp first;
        chomp( $e_process );
        
        # note that e_process is of the form: em_result=2340|nmesrvc|N/A|0.12|0.00|1300|280|0
        # the second value is the process name and is of interest
        # split based on "|"
        my @allValues = split( /\|/, $e_process );
        my $secondValue = @allValues[1];
        # do an ignore case compare of the process name
        if( lc($secondValue) eq $proc_name )
        {
            $vscrub_proc_num++;
        }
        
        chomp( $vscrub_proc_num );
    }
}
else
{
    die "em_error=Unsupported Operating System\n";    
}

#
# if the number of $proc_name process is above then zero, it means vscrub is running
# else vscrub is die
#
if( $vscrub_proc_num > 0 ) { 
    print "em_result=1\n";
} else {
    print "em_result=0\n";
} 

