#!/usr/local/bin/perl
# 
# $Header: webconf.pl 05-may-2005.10:53:23 rayleung Exp $
#
# webconf.pl
# 
# Copyright (c) 2003, 2005, Oracle. All rights reserved.  
#
#    NAME
#      webconf.pl - Web Conferencing target support
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#       rayleung 05/05/05 - separate [4053752] as a subroutine in rtcmeeting.pl  
#       rayleung 04/13/05 - bug 4256123 - remove TMPFILE 
#       rayleung 04/08/05 - bug 4283239 
#       rayleung 01/21/05 - add a RTC version checking for [4053752] 
#       stakeda  01/18/05 - [4053752] add conference minutes 
#       prbhoj   12/19/04 - Add Instance property for RTC Directory Name 
#       prbhoj   12/01/04 - Consolidation of RTC metadata and addition of new 
#                           metric for RTC 9.0.5 
# 

require "emd_common.pl";

$webconf_oh=$ENV{EM_CLIENTOH};
$webconf_dir=$ENV{EM_DIR};
$rtcVer=$ENV{RTC_VER};
my $get_status = 0;
my $get_confsvr_stats = 0;
my $get_presence_stats = 0;

foreach $i (0 .. $#ARGV) {
    if ( $ARGV[$i] eq "status" ) # Get RTC Service Status
    {
	$get_status = 1;
    }
    elsif ( $ARGV[$i] eq "confsvr") # Get Conference Server Statistics
    {
        $get_confsvr_stats = 1;
    }
    elsif ( $ARGV[$i] eq "presence") # Get Presence Server Statistics
    {
        $get_presence_stats = 1;
    }
}

if ($webconf_dir eq "") 
{
    $webconf_dir = "imeeting";
}

@command = `$webconf_oh/$webconf_dir/bin/imtctl getMonitorStats -publish true`;

# err_exit if the command fails
unless (@command)
{
    err_exit("Invalid operation\n");
}

$num_active_sessions = 0;
$num_active_clients = 0;
$all_memory_used = 0;
$num_im_chat_conferences = 0;
$num_im_total_online_users = 0;
$num_im_num_msgs_sent_last5mins = 0;
$num_im_num_new_logins_last5mins = 0;

$webconf_output = "";

foreach $line (0 .. $#command)
{
    chomp($command[$line]);               # Clean up the line (remove \n)
    $command[$line] .= " ";
    if ( length($command[$line]) > 1 )    # check only if something left over
    {
        $webconf_output = $webconf_output.$command[$line];
    }
}

# err_exit if the command's output is blank
if ($webconf_output =~ /^\s*$/)
{
    err_exit("Invalid output\n");
}

if ( index($webconf_output, "<statistics") < 0 )
{
    err_exit("Tag statistics not found\n");
}

if ( $get_status )           # Get the Status information.
{
    if ($rtcVer eq "9.0.4")  # For 9.0.4 if the service tag is present in the xml output from imtctl
                             # then the status of the service is good. So, return 1. If service tag
                             # is not present then the conferencing service is down so return 0.
    {
        if ( index($webconf_output, "<service") <= 0 ) {
            $status = 0;
        } else {
            $status = 1;
        }
    }
    elsif ($rtcVer eq "9.0.5")  # For 9.0.5 the status information is available in the xml output
                                # from imtctl. Return that status information.
    {
        if ( ($index_from = index($webconf_output, "STATUS=")) <= 0)
        {
            err_exit("Tag for status not found\n");
        }
        $index_from += 8;  # advance the index to beyond the <status> tag

        $status = substr($webconf_output, $index_from, 1);
    }
    print "em_result=$status\n";
}

if ( index($webconf_output, "<service") <= 0 )
{
    err_exit("First Tag for service not found\n");
}

if ( $get_confsvr_stats )  # get Conference metrics
{
    if ($rtcVer eq "9.0.4")
    {
    	if ( ($index_from = index($webconf_output, "type=\"clbsvr")) <= 0)
    	{
       	   err_exit("Tag for component type clbsvr not found\n");
    	}
    }
    elsif ($rtcVer eq "9.0.5")
    {
    	if ( ($index_from = index($webconf_output, "type=\"confsvr")) <= 0)
    	{
       	   err_exit("Tag for component type confsvr not found: ");
    	}
    }

    if ( ($index_to = index($webconf_output, "/component>")) <= 0) # Get the statistics for component
                                             # rtc-confsvr. Start tag is type=confsvr to end tag is
                                             # /component. 
    {
        err_exit("End Tag for component rtc-confsvr not found\n");
    }

    $index_to = $index_to - $index_from;

    $input_string = substr($webconf_output, $index_from, $index_to);

    $position = 0;
    while ( ($position = get_confservice_info($input_string, $position)) > 0 )
    {
    }
   
    print "em_result=$num_active_sessions|$num_active_clients|$all_memory_used\n";
}

if ( $get_presence_stats ) # Get Presence service status. This is only called if the version is 9.0.5
{
    if ( ($index_from = index($webconf_output, "type=\"imrtr")) <= 0)
    {
        err_exit("Tag for component Presence not found\n");
    }

    $input_string = substr($webconf_output, $index_from);

    $position = 0;
    while ( ($position = get_presence_info($input_string, $position)) > 0 )
    {
    }
    print "em_result=$num_im_chat_conferences|$num_im_total_online_users|$num_im_num_msgs_sent_last5mins|$num_im_num_new_logins_last5mins\n";
}

exit 0;
###########################################################################

sub get_confservice_info
{
    my ($str, $pos) = @_;

    if ( ($pos = index($str, "<service", $pos)) < 0 )
    {
	return 0;		# no more service tags
    }
    $pos += 8;     # go to after service tag
    $str1 = substr($str, $pos);
    #print "Scanning: $str1\n";
    if ( (($service_name, $active_sessions, $active_clients, $memory_used) = 
        ($str1 =~ /\s*name=\"(.*?)\".*?\"active\-sessions\">(.*?)<.*?\"active\-clients\">(.*?)<.*?\"memory\-used\">(.*?)<.*/)) != 0 ) 
    {
        $memory_used =~ s/,//;
        $memory_used =~ s/K//;
        $num_active_sessions += $active_sessions;
        $num_active_clients += $active_clients;
        $all_memory_used += $memory_used;
    }
    else
    {
	err_exit("Could not find confsvr stats in: $str1\n");
    }
    
    if ( ($end = index($str1, "/service>")) > 0 )
    {
	$end += $pos;
        return ($end);
    }
    else
    {
        return 0;
    }
}

###########################################################################

sub get_presence_info
{
    my ($str, $pos) = @_;

    if ( ($pos = index($str, "<service", $pos)) < 0 )
    {
        return 0;               # no more service tags
    }
    $pos += 8;     # go to after service tag
    $str1 = substr($str, $pos);

#    print "Scanning: $str1\n";

    if ( (($service_name, $im_chat_conferences, $im_total_online_users, $im_num_msgs_sent_last5mins,
        $im_num_new_logins_last5mins) =
        ($str1 =~ /\s*name=\"(.*?)\".*?\"im\-chat\-conferences\">(.*?)<.*?\"im\-total\-online\-users\">(.*?)<.*?\"im\-number\-message\-sent\-last5mins\">(.*?)<.*?\"im\-number\-new\-logins\-last5mins\">(.*?)<.*/)) != 0 )
    {
        $num_im_chat_conferences += $im_chat_conferences;
        $num_im_total_online_users += $im_total_online_users;
        $num_im_num_msgs_sent_last5mins += $im_num_msgs_sent_last5mins;
        $num_im_num_new_logins_last5mins += $im_num_new_logins_last5mins;
    }
    else
    {
        err_exit("Could not find imrtr stats in: $str1\n");
    }

    if ( ($end = index($str1, "/service>")) > 0 )
    {
        $end += $pos;
        return ($end);
    }
    else
    {
        return 0;
    }
}

sub err_exit
{
    my ($exit_error_msg) = @_;
        print "em_error=$exit_error_msg\n";
        exit 0;
}
