#  $Header: oidResponse.pl 02-mar-2004.09:49:40 xshi Exp $
# 
# Copyright (c) 2001, 2004, Oracle Corporation.  All rights reserved.  
#
#    NAME
#      oidResponse.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      This script checks if any Oracle Internet Directory Server is up and running.
#      It prints 1 in case running or 0 if no server is running.
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    xshi        03/02/04 - nt monitor 3474263 
#    vsekuboy    10/21/02 - Added ENV for PATH
#    vsekuboy    10/18/02 - Changes for HP, Linux, AIX and Tru64
#    xxu         06/25/02 - remove /usr/local/bin/perl
#    ggilchri    08/10/01 - Creation
#


$status = 0;
$procCount = 0;

if (($^O =~ "Windows") || ($^O =~ "MSWin32")) {

  @PROCS = `nmupm TopProcs`;

  foreach $oidProcessInfo (@PROCS) {
    $_ = $oidProcessInfo;
    if(/oidldapd/) {
      @data = split(/\|/, $oidProcessInfo);
      $status = 1;
      $procCount++;
    }
  }

}
else {

 $ENV{PATH} = "/bin:/usr/bin:/usr/local/bin:/usr/sbin";

 $os = `uname -s`;
 chomp ($os);
 if ($os eq "SunOS" || $os eq "Linux") {
   @PSINFO = `ps -e -o fname,ppid|grep oidldapd|awk '{print \$2}'`;
 }
 elsif ($os eq "OSF1" || $os eq "AIX") {
   @PSINFO = `ps -e -o comm,ppid|grep oidldapd|awk '{print \$2}'`;
 }
 elsif ($os eq "HP-UX") {
   $ENV{UNIX95} = "XPG4";
   @PSINFO = `ps -e -o comm,ppid|grep oidldapd|awk '{print \$2}'`;
 }
 else {
   print "Platform - $os not supported\n";
 }

 foreach $parentPID (@PSINFO)
 {
  if (1 == $parentPID)
  {
    $status = 1;
    $procCount++;
  }
 }

}

print ("em_result=$procCount|$status");



