#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/oms_assoc.pl /main/5 2010/03/29 08:23:03 rstorrie Exp $
#
# oms_assoc.pl
# 
# Copyright (c) 2005, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      oms_assoc.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    rstorrie    03/29/10 - Correct the association so that NO_VALUE is not a
#                           valid entry for repHost and repSID
#    nmittal     11/13/09 - XbranchMerge nmittal_bug-9118047 from
#                           st_emll_10.3.2
#    nmittal     11/13/09 - adding emd_common.pl to include perl debug module
#    nmittal     10/16/09 - XbranchMerge nmittal_bug-8943752 from
#                           st_emll_10.3.2
#    nmittal     10/13/09 - adding relationship between oms and weblogic server
#                           target
#    nmittal     10/02/09 - XbranchMerge nmittal_bug-8629030 from
#                           st_emll_10.3.2
#    nmittal     09/18/09 - handling wls stack changes
#    rstorrie    12/02/05 - Association script for OMS target, includes 
#                           repository and OC4J 
#    rstorrie    12/02/05 - Association script for OMS target, includes 
#                           repository and OC4J 
#    rstorrie    12/02/05 - Creation
# 

use strict;
use ecmAssoc;
use File::Spec;
use Switch;
require "emd_common.pl";

$ENV{EMDROOT} = $ENV{CCR_HOME};
require "$ENV{CCR_HOME}/sysman/admin/scripts/db/net/listenerUtil.pl";

my $oracleHome = shift;
my $targetName = shift;
my $wlsStack = shift;
my $instanceHome = shift;

if ($oracleHome eq "" || $targetName eq "") 
{
    EMD_PERL_DEBUG ("No valid ORACLE_HOME or OMS Name supplied, exiting\n");
    exit;
}

if($wlsStack eq "")
{
   EMD_PERL_DEBUG( "Invalid WLS_STACK value, exiting\n");
   exit;
}

if($wlsStack eq "TRUE" && $instanceHome eq "")
{
   EMD_PERL_DEBUG("No valid INSTANCE_HOME supplied, exiting\n");
   exit;
}

my %configParams;

my $oms_properties_file;
my $mwTargetName;
my $mwTargetType;
my $mwTargetProperties;
my $file_opened = "true";

if($wlsStack eq "TRUE")
{
   $oms_properties_file = File::Spec->catfile( $instanceHome, "sysman", "ocm", "emoms.properties" );
   $mwTargetType = $ecmAssoc::ORACLE_WEBLOGIC_SERVER;
   my $emgc_properties_file = File::Spec->catfile( $instanceHome, "emgc.properties");
   if(open (FILE, "<$emgc_properties_file"))
   {
      my $line;
      my %emgcParams;

      #Scan through the file assigning the various parameters to get the values
      while ($line = <FILE>)
      {
         chomp $line;
         if ( $line =~ /^\s*(.*?)\s*=\s*(.*?)$/)
         {
             my $value = $2;
             my $parameter = $1;

             #replace any \: with : and \= with =
             $value =~ s/\\:/:/g;
             $value =~ s/\\=/=/g;
             $emgcParams{"$parameter"}=$value;
          }
      }
      close FILE;
      my $domainName = $emgcParams{"EM_DOMAIN_NAME"};
      my $omsName = $emgcParams{"OMSNAME"};
      my $domainHome = $emgcParams{"EM_DOMAIN_HOME"};
      $mwTargetName = "/Farm_$domainName/$domainName/$omsName";
      $mwTargetProperties = $domainHome;
   }
   else
   {
     EMD_PERL_DEBUG("Error in opening $emgc_properties_file\n");   
   }
}
else
{
  $oms_properties_file = File::Spec->catfile( $oracleHome, "sysman", "config", "emoms.properties" );
  $mwTargetName = $targetName . "_OC4J_EM";
  $mwTargetType = $ecmAssoc::OC4J_TYPE;
}

if (-f $oms_properties_file)
{
    open (FILE, "<$oms_properties_file") or ($file_opened="false");
    if($file_opened eq "true")
    {
       my $line;

       #Scan through the file assigning the various parameters to get the values
       while ($line = <FILE>)
       {
           chomp $line;
           if ( $line =~ /^\s*(.*?)\s*=\s*(.*?)$/)
           {
               $configParams{"$1"}=$2;
           }
       }
       close FILE;
    
       my $repHost = $configParams{"oracle.sysman.eml.mntr.emdRepServer"};
       my $repSid = $configParams{"oracle.sysman.eml.mntr.emdRepSID"};
       my $repPort = $configParams{"oracle.sysman.eml.mntr.emdRepPort"};
       my $repConn = $configParams{"oracle.sysman.eml.mntr.emdRepConnectDescriptor"};
    
       $repConn =~ s/\\=/=/g;
       if ( $repHost ne '' && $repHost ne 'NO_VALUE' && $repSid ne '' && $repSid ne 'NO_VALUE' &&  $repPort ne '' )
       {        
          print ("em_result=$ecmAssoc::CONNECTS_TO||$ecmAssoc::ORACLE_DATABASE_TYPE|$repHost:$repPort:$repSid\n");
       }
       elsif ( $repConn ne '' )
       {
          my $addresses = getParamValueListFor($repConn,"ADDRESS");
          my $connectData = getParamValueListFor($repConn,"CONNECT_DATA");
          my $sidOrService = "";
          my ($addrInfo,$connInfo);
          foreach $addrInfo(@$addresses)
          {
              foreach $connInfo(@$connectData)
              {
                  if (defined($connInfo->{SERVICE_NAME}))
                  {
                      $sidOrService = $connInfo->{SERVICE_NAME};
                  }
                  elsif (defined($connInfo->{SID}))
                  {
                      $sidOrService = $addrInfo->{PORT}.":".$connInfo->{SID};
                  }
                  print ("em_result=$ecmAssoc::CONNECTS_TO||$ecmAssoc::ORACLE_DATABASE_TYPE|$addrInfo->{HOST}:$sidOrService\n");
             }
          }
       }
       else
       {
           EMD_PERL_DEBUG("No valid database connection found in emoms.properties\n");   
       }
    }
    else
    {
      EMD_PERL_DEBUG("Unable to open $! \n",$oms_properties_file);
    }
    print ("em_result=$ecmAssoc::DEPENDS_ON|$mwTargetName|$mwTargetType|$mwTargetProperties|\n");
} 
