# $Header: opmnManagedList.pl 28-jul-2003.17:44:39 jtrichar Exp $
#
# opmnManagedList.pl
# 
# Copyright (c) 2002, 2003, Oracle Corporation.  All rights reserved.  
#
#    NAME
#      opmnManagedList.pl - gets a list of instances managed by opmn
#
#    DESCRIPTION
#      opmnManagedList.pl <oracle_home>
#
#      where
#         <oracle_home> is the oracle home in which the ias is running
#
#    returns: 
#      em_result=<ias-component>|<process-type>|<module-id>
#
#    NOTES
#
#
#    MODIFIED   (MM/DD/YY)
#    jtrichar   07/28/03 - jtrichar_bug-3038046
#    klmichae   12/26/02 - look for process-type and ias-component
#    klmichae   12/17/02 - klmichae_opmn_aggregate
#    klmichae   12/17/02 - Initial revision

use strict;
# open oracle_home/opmn/conf/opmn.xml
my $configFileName = $ARGV[0]."/opmn/conf/opmn.xml";
if (!open (CONFIGFILE,$configFileName))
{
    print "Error: File $configFileName not found.";
    exit 1;
}

# Walk through all the lines looking for the "<ias-component" tags and then the
# <process-type" tags with it
my $typeLine;
my $component = "";
my $insideComponentTag = 0;
while(<CONFIGFILE>)
{
  # See if this is the ias-component tag
  if( $insideComponentTag == 0 )
  {
    # See if this is a component tag
    $component = getIASComponent( $_ );
    if( $component ne "" ) 
    {
      $insideComponentTag = 1;
    }
  } else {
    # See if this is the end of the component tag
    if( index( $_ , "</ias-component>" ) != -1 )
    {
      # Done with this component
      $insideComponentTag = 0;
    } else {
      # We're still processing the component, so see if this is process type tag
      $typeLine = getProcessType( $_ );
      if( $typeLine ne "" ) 
      {
        # This was a process type line, so output the result
        print "em_result=$component|$typeLine\n";
      }
    }
  }
} # end while
close(CONFIGFILE);

# See if this line is a process-type line 
# The following is an example of a process-type line:
#  <process-type id="OC4J_EM" module-id="OC4J">
#
# parameters:
#  line - the current line
# returns:
#  {id}|{module-id} or an empty string is this is now a process-type line
sub getProcessType
{
  my $line = shift(@_);
  my $processType;
  
  # Is this a process type line
  my $position = index( $line, "<process-type ");
  if( $position != -1 ) 
  {
    # set line to the reminder of the line: $position + length("<process-type ")
    $line = substr( $line, $position+14 );

    # Now find the id=" part
    $position = index( $line, "id=\"" );
    if( $position != -1 ) 
    {
      # Find the end quote and get the component name
      $line = substr( $line, $position+4 );
      $position = index( $line, '"' );
      if( $position != -1 ) 
      {              
        $processType = substr($line, 0, $position );
      }

      # Now find the module-id
      $position = index( $line, "module-id=\"" ); 
      if( $position != -1 ) 
      {
        # Find the end quote and get the module id
        $line = substr( $line, $position+11 );
        $position = index( $line, '"' );
        if( $position != -1 ) 
        {              
          my $module = substr($line, 0, $position );
          return "$processType|$module";
        }
      } # endif if( $position != -1 ) 
    } # endif if( $position != -1 ) 
  } # endif if( $position != -1 )     

  return "";
}

# See if the specified line is a ias-component line 
# The following is an example of an ias-component line:
# <ias-component id="HTTP_Server">
#
# parameters
#  line - the current line
# returns:
#  the component name or an empty string is this is now an ias-component line
sub getIASComponent
{
  my $line = shift(@_);
  my $iasComponent;
  
  # Is this an ias component line
  my $position = index( $line, "<ias-component ");
  if( $position != -1 ) 
  {
    # set line to the reminder of the line: $position + length("<process-type ")
    $line = substr( $line, $position+14 );
    
    # Now find the id=" part
    $position = index( $line, "id=\"" );
    if( $position != -1 ) 
    {
      # Find the end quote and get the component name
      $line = substr( $line, $position+4 );
      $position = index( $line, '"' );
      if( $position != -1 ) 
      {              
        $iasComponent = substr($line, 0, $position );
        return $iasComponent;
      }
    } # endif if( $position != -1 ) 
  } # endif if( $position != -1 )     

  return "";
}


