#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/oracle_emd_targets.pl /main/1 2008/10/14 10:27:54 rstorrie Exp $
#
# oracle_emd_targets.pl
# 
# Copyright (c) 2008, Oracle and/or its affiliates. All rights reserved.
#
#    NAME
#      oracle_emd_targets.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    rstorrie    10/14/08 - Add a shorthostname check to get org_id
#    rstorrie    10/13/08 - Move print em_result to be last line rather than
#                           separate lines
#    rstorrie    10/09/08 - Script collect the agent monitored targets and
#                           collect if the db is instrumented
#    rstorrie    10/09/08 - Creation
# 
#!/usr/local/bin/perl

use strict;
use Config;
use File::Spec;
use ias::simpleXPath;

my $agentHome = shift;

# Retrieve the name of of the agent from its targets.xml
# This will guarantee to us that we are using the same name as grid control
# Write this and the true agent home to ccr targets.xml
my $targetsFile = File::Spec->catfile($agentHome, "sysman", "emd", "targets.xml");
if (-f $targetsFile)
{
    open (FILE, "<$targetsFile") or exit;
    close FILE;

    # Setup a hash for the instrumented files found
    my %dbFilesFound=();

    # Get the hostname of the host target
    my $hostName;
    my @host = simpleXPathQuery($targetsFile, 'Targets/Target[@TYPE="host"]');
    foreach my $hosts (@host)
    {
       $hostName = $hosts->{'NAME'};
    }
    # Get the targets from target.xml 
    my @allTargets = simpleXPathQuery($targetsFile, "Targets/Target");
    for my $target (@allTargets)
    {
      my $targetName = $$target{'NAME'};
      my $targetType = $$target{'TYPE'};
      my ($targetHome, $targetMachine, $targetSID, $dbInstrumented);
      # Print the name and type for each target

      # Retrieve the properties for each target
      my @targetProperties = simpleXPathQuery($targetsFile, 'Targets/Target[@TYPE="'.$targetType.'"][@NAME="'.$targetName.'"]/Property');
      foreach my $property (@targetProperties)
      {
         # Get the oraclehome and machinename if they are available
         if ((lc($$property{'NAME'}) eq "oraclehome") || (lc($$property{'NAME'}) eq "oracle_home")) 
         { 
             $targetHome = $$property{'VALUE'};
         }

         # Get the machine the target is running on
         if (lc($$property{'NAME'}) =~ m/\s*machine/)
         {
             $targetMachine = $$property{'VALUE'};
         }

         # Get the SID if its present, if its a db home lets check
         # the agent state directory for an instrumented indicator.
         if (lc($$property{'NAME'}) eq "sid")
         {
             $targetSID = $$property{'VALUE'};
             if (lc($targetType) eq "oracle_database")
             {
                my $instrumentedDir = File::Spec->catfile($agentHome, "sysman", "emd", "state");
                my $instrumentedFile = File::Spec->catfile($instrumentedDir, $targetSID.".DB_ocm");
                if (-e $instrumentedFile)
                {
                    # We found a database file, add it to the has
                    $dbFilesFound{$targetSID.".DB_ocm"} = 1;
                    $dbInstrumented = getPropertyFromFile($instrumentedDir, "/".$targetSID.".DB_ocm","ocm_instrumented");
                }
             }
         } 
      }

      # if there is no Oracle Home then use the home 
      # we are running in except is the taget is host
      # it will have no oracle home.
      if ($targetHome eq "") 
      {
         $targetHome = $ENV{LL_ORACLE_HOME};
      }  
      if (lc($targetType) eq "host")
      {
         $targetHome = "";
      }
      if (lc($targetType) eq "oracle_database")
      {
         if ($dbInstrumented eq 1)
         {
           $dbInstrumented = "Y";
         }
         if ($dbInstrumented eq 0)
         {
           $dbInstrumented = "N";
         }
      }   
      # Lets get the org id from uplinkreg.bin
      # The location cannot be determined from CCR_CONFIG 
      # this is because that only applies to the OCM collector home 
       my $uplinkFile = File::Spec->catfile($targetHome,"ccr", "hosts", $hostName,"config","default");
      my $shortHost = $hostName;
      $shortHost =~ s/\..*//;
      if (-r $uplinkFile)
      {
      } else {
          $uplinkFile = File::Spec->catfile($targetHome,"ccr", "hosts",$shortHost,"config","default");
         if (-r $uplinkFile)
         {
         } else {
           $uplinkFile = File::Spec->catfile($targetHome,"ccr","config","default");
         }
      } # End checks on uplinkFile location

      my $targetOrgId = getPropertyFromFile($uplinkFile,"/uplinkreg.bin","key.id");
      print ("em_result=".$targetType."|".$targetName."|".$targetHome."|".$dbInstrumented."|".$targetMachine."|".$targetOrgId."\n");
    } # End of Target loop

    # Do a final clear up of the old DB_ocm files
    my $stateDir = File::Spec->catfile($agentHome, "sysman", "emd","state"); 
    opendir(DIR,$stateDir);
    my @files = grep {/\.DB_ocm$/ }  readdir(DIR);
    closedir DIR;
    foreach my $file (@files) 
    {
      if (!exists $dbFilesFound{$file})
      {
         unlink "$stateDir/$file";
      }
    }
}

sub getPropertyFromFile
{
  my ($emdHomeRef, $fileSpec, $property, $delim) = @_;

  my $propertyValue = "";
  my $propertiesFile = $emdHomeRef . $fileSpec;
  my ($propertiesLine, @propInfo);

  if (!defined($delim))
  {
    $delim = "=";
  }
  if (-e $propertiesFile)
  {
    open (PROPERTIES_FILE_READER, $propertiesFile);
    while($propertiesLine = <PROPERTIES_FILE_READER>)
    {
      chomp($propertiesLine);
      if (index($propertiesLine, "$property") eq 0)
      {
        @propInfo = split(/$delim/ ,$propertiesLine);
        if ($propInfo[0] eq $property)
        {
          $propertyValue = $propInfo[1];
          last;
        }
      }
    }
    close PROPERTIES_FILE_READER;
  }
  return $propertyValue;
}
