#Obtains configuration for RPMApp target
#
# usage:
# oracle_retail_RPMApp.pl <targetname> <metricname>
#   where <metricname> can be any of the following:
#     getProductInfo

use strict;
use Switch;
use ecmAssoc;

my $targetName = shift;
chomp $targetName;
&usage() unless $targetName;

my $TRUE = 1;
my $FALSE = 0;

my $DEBUG = $FALSE;

my $metricname = shift;
chomp $metricname;
&CheckForMetricname() unless $metricname;

if ($metricname ne "getProductInfo")
{
    print "Invalid metricname.\n";
    exit 1;
}

my $targetType = $ecmAssoc::ORACLE_RETAIL_RPMAPP_TYPE;

$targetName =~ s/\./\\./g;
$targetName =~ s/\+/\\+/g;

# Use LL_ORACLE_HOME provided by OCM to locate the ORACLE_HOME path.
# If LL_ORACLE_HOME is not defined for some reason then try ORACLE_HOME
my $oraHome;
if (defined $ENV{LL_ORACLE_HOME}) {
    $oraHome = $ENV{LL_ORACLE_HOME};
} elsif (defined $ENV{ORACLE_HOME}) {
    $oraHome = $ENV{ORACLE_HOME};
} else {
    die "Could not find config root directory."
        . " Neither LL_ORACLE_HOME nor ORACLE_HOME is set.\n";
}

# Oracle Retail inventory file created or updated by retail product installer
my $rpmJavaEEInventoryFile = "${oraHome}/retail_inventory/oracle_retail_RPMApp.properties";

# MAIN
# collect config data and store in %rpmConfigData associative array
my %rpmConfigData = &collectConfigData();
&printConfigData(%rpmConfigData);
exit 0;

# collect config data and store in %configData hash
sub collectConfigData {
    my %configData;

    my ($Parameter, $Value, $OC4JInstanceDirectory, $ApplicationDeployment, 
        $hostname, $portNo, @data, $version, $string, $JVersionPath, 
        @arrayContents, @ProcessType, $j, $found);

    # begin
    # Collecting config data for $targetName and store in the %configData associative array

    open(MYFILE,"$rpmJavaEEInventoryFile") || die "Can't open the file ${rpmJavaEEInventoryFile}: $!";
    while(defined($a=<MYFILE>))
    {
        $a =~ m/$targetName\+(.*)=(.*)/;
        $Parameter = $1;
        $Value = $2;
        switch($Parameter)
        {
            case "RPM_VERSION"        { $configData{'RPM_VERSION'} = $Value; }
            case "RPM_INSTALL_DATE"   { $configData{'RPM_INSTALL_DATE'} = $Value; }
        }
    }
    close(MYFILE);

    return %configData;
}


# Print config data to stdout. Config metrics printed are determined by
# the metric name provided on the command line.
sub printConfigData {
    my (%configData) = @_;
    my ($em_result);

    switch($metricname)
    {
        case "getProductInfo"
        { 
            $em_result = "em_result=" 
                         . "$configData{'RPM_VERSION'}" . "|" 
                         . "$configData{'RPM_INSTALL_DATE'}";
        }
    } 

    print "$em_result\n";
}

sub usage {
    print "targetname and metricname not provided...." 
          . "\n" . "Usage: $0 <target-name> <metricname>\n";
    exit 1;
}

sub CheckForMetricname {
    print "metricname not provided...." . "\n" . "Usage: $0 <target-name> <metricname>" . "\n";
    exit 1;
}
